/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.upgrade.v7_0_0.util.GroupTable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Locale;

public class UpgradeGroup
extends UpgradeProcess {
    protected void createIndex() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL("create index IX_8257E37B on Group_ (classNameId, classPK)");
        }
    }

    protected void doUpgrade() throws Exception {
        this.alter(GroupTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterColumnType((UpgradeProcess)this, "name", "STRING null")});
        this.createIndex();
        this.updateGlobalGroupName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateGlobalGroupName() throws Exception {
        ArrayList<Long> companyIds = new ArrayList<Long>();
        try (PreparedStatement ps = this.connection.prepareStatement("select companyId from Company");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                companyIds.add(companyId);
            }
        }
        long companyThreadLocalCompanyId = CompanyThreadLocal.getCompanyId();
        try {
            for (Long companyId : companyIds) {
                LocalizedValuesMap localizedValuesMap = new LocalizedValuesMap();
                CompanyThreadLocal.setCompanyId((Long)companyId);
                for (Locale locale : LanguageUtil.getAvailableLocales()) {
                    localizedValuesMap.put(locale, LanguageUtil.get((Locale)locale, (String)"global"));
                }
                String nameXML = LocalizationUtil.getXml((LocalizedValuesMap)localizedValuesMap, (String)"global");
                PreparedStatement ps = this.connection.prepareStatement("update Group_ set name = ? where companyId = ? and friendlyURL = '/global'");
                Throwable throwable = null;
                try {
                    ps.setString(1, nameXML);
                    ps.setLong(2, companyId);
                    ps.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ps == null) continue;
                    if (throwable != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ps.close();
                }
            }
        }
        finally {
            CompanyThreadLocal.setCompanyId((Long)companyThreadLocalCompanyId);
        }
    }
}

