/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_5;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.TreeModel;
import com.liferay.portal.kernel.tree.TreeModelTasks;
import com.liferay.portal.kernel.tree.TreeModelTasksAdapter;
import com.liferay.portal.kernel.tree.TreePathUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.PortalInstances;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class UpgradeGroup
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeGroup.class);

    protected void doUpgrade() throws Exception {
        this.updateParentGroup();
    }

    @Deprecated
    protected void rebuildTree(long companyId, final PreparedStatement preparedStatement) throws PortalException {
        TreePathUtil.rebuildTree((long)companyId, (long)0L, (String)"/", (TreeModelTasks)new TreeModelTasksAdapter<GroupTreeModel>(){

            public List<GroupTreeModel> findTreeModels(long previousId, long companyId, long parentPrimaryKey, int size) {
                ArrayList<GroupTreeModel> treeModels = new ArrayList<GroupTreeModel>();
                try (PreparedStatement ps = UpgradeGroup.this.connection.prepareStatement("select groupId from Group_ group_ where group_.groupId > ? and group_.companyId = ? and group_.parentGroupId = ?");){
                    ps.setLong(1, previousId);
                    ps.setLong(2, companyId);
                    ps.setLong(3, parentPrimaryKey);
                    ps.setFetchSize(size);
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            long folderId = rs.getLong(1);
                            GroupTreeModel treeModel = new GroupTreeModel(preparedStatement);
                            treeModel.setPrimaryKeyObj(Long.valueOf(folderId));
                            treeModels.add(treeModel);
                        }
                    }
                }
                catch (SQLException sqle) {
                    _log.error((Object)("Unable to get groups with parent primary key " + parentPrimaryKey), (Throwable)sqle);
                }
                return treeModels;
            }

            public void rebuildDependentModelsTreePaths(long parentPrimaryKey, String treePath) throws PortalException {
                try {
                    preparedStatement.setString(1, treePath);
                    preparedStatement.setLong(2, parentPrimaryKey);
                    preparedStatement.addBatch();
                }
                catch (SQLException sqle) {
                    _log.error((Object)("Unable to update groups with tree path " + treePath), (Throwable)sqle);
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateParentGroup() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(7);
            sb.append("select stagingGroup_.groupId, ");
            sb.append("liveGroup_.parentGroupId from Group_ stagingGroup_ ");
            sb.append("inner join Group_ liveGroup_ on ");
            sb.append("(liveGroup_.groupId = stagingGroup_.liveGroupId) ");
            sb.append("where (stagingGroup_.remoteStagingGroupCount = 0) and ");
            sb.append("(liveGroup_.parentGroupId != ");
            sb.append("stagingGroup_.parentGroupId)");
            try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
                 PreparedStatement ps2 = this.connection.prepareStatement("select treePath from Group_ where groupId = ?");
                 PreparedStatement ps3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update Group_ set parentGroupId = ?, treePath = ?where groupId = ?");
                 ResultSet rs1 = ps1.executeQuery();){
                while (rs1.next()) {
                    ResultSet rs2;
                    block73: {
                        long groupId = rs1.getLong(1);
                        long parentGroupId = rs1.getLong(2);
                        ps2.setLong(1, parentGroupId);
                        rs2 = ps2.executeQuery();
                        Throwable throwable = null;
                        try {
                            String treePath = null;
                            if (rs2.next()) {
                                treePath = rs2.getString("treePath");
                                treePath = treePath.concat(String.valueOf(groupId));
                                treePath = treePath.concat("/");
                            } else {
                                if (_log.isWarnEnabled()) {
                                    _log.warn((Object)("Unable to find group " + parentGroupId));
                                }
                                StringBundler treePathSB = new StringBundler(5);
                                treePathSB.append("/");
                                treePathSB.append(parentGroupId);
                                treePathSB.append("/");
                                treePathSB.append(groupId);
                                treePathSB.append("/");
                                treePath = treePathSB.toString();
                            }
                            ps3.setLong(1, parentGroupId);
                            ps3.setString(2, treePath);
                            ps3.setLong(3, groupId);
                            ps3.addBatch();
                            if (rs2 == null) continue;
                            if (throwable == null) break block73;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (rs2 == null) throw throwable3;
                                if (throwable == null) {
                                    rs2.close();
                                    throw throwable3;
                                }
                                try {
                                    rs2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            rs2.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    rs2.close();
                }
                ps3.executeBatch();
                return;
            }
        }
    }

    @Deprecated
    protected void updateTreePath() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long[] companyIds;
            for (long companyId : companyIds = PortalInstances.getCompanyIdsBySQL()) {
                try (PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update Group_ set treePath = ? where groupId = ?");){
                    try {
                        this.rebuildTree(companyId, preparedStatement);
                    }
                    catch (PortalException pe) {
                        _log.error((Object)("Unable to update tree paths for company " + companyId), (Throwable)pe);
                    }
                    preparedStatement.executeBatch();
                }
                catch (SQLException sqle) {
                    _log.error((Object)"Unable to update tree paths", (Throwable)sqle);
                }
            }
        }
    }

    private class GroupTreeModel
    implements TreeModel {
        private long _groupId;
        private final PreparedStatement _ps;

        public GroupTreeModel(PreparedStatement ps) {
            this._ps = ps;
        }

        public String buildTreePath() throws PortalException {
            return null;
        }

        public Serializable getPrimaryKeyObj() {
            return Long.valueOf(this._groupId);
        }

        public String getTreePath() {
            return null;
        }

        public void setPrimaryKeyObj(Serializable primaryKeyObj) {
            this._groupId = (Long)primaryKeyObj;
        }

        public void updateTreePath(String treePath) {
            try {
                this._ps.setString(1, treePath);
                this._ps.setLong(2, this._groupId);
                this._ps.addBatch();
            }
            catch (SQLException sqle) {
                _log.error((Object)("Unable to update tree path: " + treePath), (Throwable)sqle);
            }
        }
    }
}

