/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryProvider;
import com.liferay.portal.kernel.repository.capabilities.TrashCapability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portlet.documentlibrary.service.base.DLTrashServiceBaseImpl;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFileShortcutPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;

public class DLTrashServiceImpl
extends DLTrashServiceBaseImpl {
    @BeanReference(type=RepositoryProvider.class)
    protected RepositoryProvider repositoryProvider;

    public FileEntry moveFileEntryFromTrash(long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        Repository repository = this.repositoryProvider.getFileEntryRepository(fileEntryId);
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntry, "UPDATE");
        Folder destinationFolder = null;
        if (newFolderId != 0L) {
            destinationFolder = repository.getFolder(newFolderId);
        }
        TrashCapability trashCapability = (TrashCapability)repository.getCapability(TrashCapability.class);
        return trashCapability.moveFileEntryFromTrash(this.getUserId(), fileEntry, destinationFolder, serviceContext);
    }

    public FileEntry moveFileEntryToTrash(long fileEntryId) throws PortalException {
        Repository repository = this.repositoryProvider.getFileEntryRepository(fileEntryId);
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntry, "DELETE");
        TrashCapability trashCapability = (TrashCapability)repository.getCapability(TrashCapability.class);
        return trashCapability.moveFileEntryToTrash(this.getUserId(), fileEntry);
    }

    public FileShortcut moveFileShortcutFromTrash(long fileShortcutId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        Repository repository = this.repositoryProvider.getFileShortcutRepository(fileShortcutId);
        FileShortcut fileShortcut = repository.getFileShortcut(fileShortcutId);
        DLFileShortcutPermission.check(this.getPermissionChecker(), fileShortcut, "UPDATE");
        Folder destinationFolder = null;
        if (newFolderId != 0L) {
            destinationFolder = repository.getFolder(newFolderId);
        }
        TrashCapability trashCapability = (TrashCapability)repository.getCapability(TrashCapability.class);
        return trashCapability.moveFileShortcutFromTrash(this.getUserId(), fileShortcut, destinationFolder, serviceContext);
    }

    public FileShortcut moveFileShortcutToTrash(long fileShortcutId) throws PortalException {
        Repository repository = this.repositoryProvider.getFileShortcutRepository(fileShortcutId);
        FileShortcut fileShortcut = repository.getFileShortcut(fileShortcutId);
        DLFileShortcutPermission.check(this.getPermissionChecker(), fileShortcut, "DELETE");
        TrashCapability trashCapability = (TrashCapability)repository.getCapability(TrashCapability.class);
        return trashCapability.moveFileShortcutToTrash(this.getUserId(), fileShortcut);
    }

    public Folder moveFolderFromTrash(long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        Repository repository = this.repositoryProvider.getFolderRepository(folderId);
        Folder folder = repository.getFolder(folderId);
        DLFolderPermission.check(this.getPermissionChecker(), folder, "UPDATE");
        Folder destinationFolder = null;
        if (parentFolderId != 0L) {
            destinationFolder = repository.getFolder(parentFolderId);
        }
        TrashCapability trashCapability = (TrashCapability)repository.getCapability(TrashCapability.class);
        return trashCapability.moveFolderFromTrash(this.getUserId(), folder, destinationFolder, serviceContext);
    }

    public Folder moveFolderToTrash(long folderId) throws PortalException {
        Repository repository = this.repositoryProvider.getFolderRepository(folderId);
        Folder folder = repository.getFolder(folderId);
        DLFolderPermission.check(this.getPermissionChecker(), folder, "DELETE");
        TrashCapability trashCapability = (TrashCapability)repository.getCapability(TrashCapability.class);
        return trashCapability.moveFolderToTrash(this.getUserId(), folder);
    }

    public void restoreFileEntryFromTrash(long fileEntryId) throws PortalException {
        Repository repository = this.repositoryProvider.getFileEntryRepository(fileEntryId);
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntry, "DELETE");
        TrashCapability trashCapability = (TrashCapability)repository.getCapability(TrashCapability.class);
        trashCapability.restoreFileEntryFromTrash(this.getUserId(), fileEntry);
    }

    public void restoreFileShortcutFromTrash(long fileShortcutId) throws PortalException {
        Repository repository = this.repositoryProvider.getFileShortcutRepository(fileShortcutId);
        FileShortcut fileShortcut = repository.getFileShortcut(fileShortcutId);
        DLFileShortcutPermission.check(this.getPermissionChecker(), fileShortcut, "DELETE");
        TrashCapability trashCapability = (TrashCapability)repository.getCapability(TrashCapability.class);
        trashCapability.restoreFileShortcutFromTrash(this.getUserId(), fileShortcut);
    }

    public void restoreFolderFromTrash(long folderId) throws PortalException {
        Repository repository = this.repositoryProvider.getFolderRepository(folderId);
        Folder folder = repository.getFolder(folderId);
        DLFolderPermission.check(this.getPermissionChecker(), folder, "DELETE");
        TrashCapability trashCapability = (TrashCapability)repository.getCapability(TrashCapability.class);
        trashCapability.restoreFolderFromTrash(this.getUserId(), folder);
    }
}

