/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.exportimport.service.impl;

import com.liferay.document.library.kernel.util.DLValidatorUtil;
import com.liferay.exportimport.kernel.controller.ExportController;
import com.liferay.exportimport.kernel.controller.ExportImportControllerRegistryUtil;
import com.liferay.exportimport.kernel.controller.ImportController;
import com.liferay.exportimport.kernel.exception.LARFileNameException;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManagerUtil;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portlet.exportimport.service.base.ExportImportLocalServiceBaseImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class ExportImportLocalServiceImpl
extends ExportImportLocalServiceBaseImpl {
    public File exportLayoutsAsFile(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        try {
            ExportController layoutExportController = ExportImportControllerRegistryUtil.getExportController((String)Layout.class.getName());
            return layoutExportController.export(exportImportConfiguration);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public long exportLayoutsAsFileInBackground(long userId, ExportImportConfiguration exportImportConfiguration) throws PortalException {
        if (!DLValidatorUtil.isValidName((String)exportImportConfiguration.getName())) {
            throw new LARFileNameException(exportImportConfiguration.getName());
        }
        HashMap<String, Long> taskContextMap = new HashMap<String, Long>();
        taskContextMap.put("exportImportConfigurationId", exportImportConfiguration.getExportImportConfigurationId());
        BackgroundTask backgroundTask = BackgroundTaskManagerUtil.addBackgroundTask((long)userId, (long)exportImportConfiguration.getGroupId(), (String)exportImportConfiguration.getName(), (String)"com.liferay.exportimport.internal.background.task.LayoutExportBackgroundTaskExecutor", taskContextMap, (ServiceContext)new ServiceContext());
        return backgroundTask.getBackgroundTaskId();
    }

    public long exportLayoutsAsFileInBackground(long userId, long exportImportConfigurationId) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId);
        return this.exportLayoutsAsFileInBackground(userId, exportImportConfiguration);
    }

    public File exportPortletInfoAsFile(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        try {
            ExportController portletExportController = ExportImportControllerRegistryUtil.getExportController((String)Portlet.class.getName());
            return portletExportController.export(exportImportConfiguration);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public long exportPortletInfoAsFileInBackground(long userId, ExportImportConfiguration exportImportConfiguration) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        String fileName = MapUtil.getString((Map)settingsMap, (String)"fileName");
        if (!DLValidatorUtil.isValidName((String)fileName)) {
            throw new LARFileNameException(fileName);
        }
        HashMap<String, Long> taskContextMap = new HashMap<String, Long>();
        taskContextMap.put("exportImportConfigurationId", exportImportConfiguration.getExportImportConfigurationId());
        BackgroundTask backgroundTask = BackgroundTaskManagerUtil.addBackgroundTask((long)userId, (long)exportImportConfiguration.getGroupId(), (String)exportImportConfiguration.getName(), (String)"com.liferay.exportimport.internal.background.task.PortletExportBackgroundTaskExecutor", taskContextMap, (ServiceContext)new ServiceContext());
        return backgroundTask.getBackgroundTaskId();
    }

    public long exportPortletInfoAsFileInBackground(long userId, long exportImportConfigurationId) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId);
        return this.exportPortletInfoAsFileInBackground(userId, exportImportConfiguration);
    }

    public void importLayouts(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        try {
            ImportController layoutImportController = ExportImportControllerRegistryUtil.getImportController((String)Layout.class.getName());
            layoutImportController.importFile(exportImportConfiguration, file);
        }
        catch (PortalException pe) {
            Throwable cause = pe.getCause();
            if (cause instanceof LocaleException) {
                throw (PortalException)cause;
            }
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public void importLayouts(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)inputStream);
            this.importLayouts(exportImportConfiguration, file);
        }
        catch (IOException ioe) {
            throw new SystemException("Unable to process LAR file for layout import due to a file system error", (Throwable)ioe);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public void importLayoutsDataDeletions(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        try {
            ImportController layoutImportController = ExportImportControllerRegistryUtil.getImportController((String)Layout.class.getName());
            layoutImportController.importDataDeletions(exportImportConfiguration, file);
        }
        catch (PortalException pe) {
            Throwable cause = pe.getCause();
            if (cause instanceof LocaleException) {
                throw (PortalException)cause;
            }
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public long importLayoutsInBackground(long userId, ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        HashMap<String, Long> taskContextMap = new HashMap<String, Long>();
        taskContextMap.put("exportImportConfigurationId", exportImportConfiguration.getExportImportConfigurationId());
        BackgroundTask backgroundTask = BackgroundTaskManagerUtil.addBackgroundTask((long)userId, (long)exportImportConfiguration.getGroupId(), (String)exportImportConfiguration.getName(), (String)"com.liferay.exportimport.internal.background.task.LayoutImportBackgroundTaskExecutor", taskContextMap, (ServiceContext)new ServiceContext());
        backgroundTask.addAttachment(userId, file.getName(), file);
        return backgroundTask.getBackgroundTaskId();
    }

    public long importLayoutsInBackground(long userId, ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)inputStream);
            long l = this.importLayoutsInBackground(userId, exportImportConfiguration, file);
            return l;
        }
        catch (IOException ioe) {
            throw new SystemException("Unable to process LAR file for layout import due to a file system error", (Throwable)ioe);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public long importLayoutsInBackground(long userId, long exportImportConfigurationId, File file) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId);
        return this.importPortletInfoInBackground(userId, exportImportConfiguration, file);
    }

    public long importLayoutsInBackground(long userId, long exportImportConfigurationId, InputStream inputStream) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId);
        return this.importLayoutsInBackground(userId, exportImportConfiguration, inputStream);
    }

    public void importPortletDataDeletions(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        try {
            ImportController portletImportController = ExportImportControllerRegistryUtil.getImportController((String)Portlet.class.getName());
            portletImportController.importDataDeletions(exportImportConfiguration, file);
        }
        catch (PortalException pe) {
            Throwable cause = pe.getCause();
            if (cause instanceof LocaleException) {
                throw (PortalException)cause;
            }
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public void importPortletInfo(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        try {
            ImportController portletImportController = ExportImportControllerRegistryUtil.getImportController((String)Portlet.class.getName());
            portletImportController.importFile(exportImportConfiguration, file);
        }
        catch (PortalException pe) {
            for (Throwable cause = pe.getCause(); cause != null; cause = cause.getCause()) {
                if (cause instanceof LocaleException) {
                    throw (PortalException)cause;
                }
                if (!(cause instanceof PortletDataException)) break;
            }
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public void importPortletInfo(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)inputStream);
            this.importPortletInfo(exportImportConfiguration, file);
        }
        catch (IOException ioe) {
            throw new SystemException("Unable to process LAR file for layout import due to a file system error", (Throwable)ioe);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public long importPortletInfoInBackground(long userId, ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        HashMap<String, Long> taskContextMap = new HashMap<String, Long>();
        taskContextMap.put("exportImportConfigurationId", exportImportConfiguration.getExportImportConfigurationId());
        BackgroundTask backgroundTask = BackgroundTaskManagerUtil.addBackgroundTask((long)userId, (long)exportImportConfiguration.getGroupId(), (String)exportImportConfiguration.getName(), (String)"com.liferay.exportimport.internal.background.task.PortletImportBackgroundTaskExecutor", taskContextMap, (ServiceContext)new ServiceContext());
        backgroundTask.addAttachment(userId, file.getName(), file);
        return backgroundTask.getBackgroundTaskId();
    }

    public long importPortletInfoInBackground(long userId, ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)inputStream);
            long l = this.importPortletInfoInBackground(userId, exportImportConfiguration, file);
            return l;
        }
        catch (IOException ioe) {
            throw new SystemException("Unable to process LAR file for portlet import due to a file system error", (Throwable)ioe);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public long importPortletInfoInBackground(long userId, long exportImportConfigurationId, File file) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId);
        return this.importPortletInfoInBackground(userId, exportImportConfiguration, file);
    }

    public long importPortletInfoInBackground(long userId, long exportImportConfigurationId, InputStream inputStream) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId);
        return this.importPortletInfoInBackground(userId, exportImportConfiguration, inputStream);
    }

    public MissingReferences validateImportLayoutsFile(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        try {
            ImportController layoutImportController = ExportImportControllerRegistryUtil.getImportController((String)Layout.class.getName());
            return layoutImportController.validateFile(exportImportConfiguration, file);
        }
        catch (PortalException pe) {
            Throwable cause = pe.getCause();
            if (cause instanceof LocaleException) {
                throw (PortalException)cause;
            }
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public MissingReferences validateImportLayoutsFile(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)inputStream);
            MissingReferences missingReferences = this.validateImportLayoutsFile(exportImportConfiguration, file);
            return missingReferences;
        }
        catch (IOException ioe) {
            throw new SystemException("Unable to process LAR file for layout import validation due to a file system error", (Throwable)ioe);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public MissingReferences validateImportPortletInfo(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        try {
            ImportController portletImportController = ExportImportControllerRegistryUtil.getImportController((String)Portlet.class.getName());
            return portletImportController.validateFile(exportImportConfiguration, file);
        }
        catch (PortalException pe) {
            Throwable cause = pe.getCause();
            if (cause instanceof LocaleException) {
                throw (PortalException)cause;
            }
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public MissingReferences validateImportPortletInfo(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)inputStream);
            MissingReferences missingReferences = this.validateImportPortletInfo(exportImportConfiguration, file);
            return missingReferences;
        }
        catch (IOException ioe) {
            throw new SystemException("Unable to process LAR file for portlet import validation due to a file system error", (Throwable)ioe);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }
}

