/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPTaglibVariableCheck
extends BaseFileCheck {
    private final Pattern _taglibVariablePattern = Pattern.compile("(\t*String (\\w+) = (.*);)\n\\s*%>\\s+(<[\\S\\s]*?>)\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (this.isSubrepository() || this.isReadOnly(absolutePath)) {
            return content;
        }
        content = this._formatTaglibVariable(fileName, content);
        return content;
    }

    private String _formatTaglibVariable(String fileName, String content) {
        Matcher matcher = this._taglibVariablePattern.matcher(content);
        while (matcher.find()) {
            String nextTag = matcher.group(4);
            String taglibValue = matcher.group(3);
            String variableName = matcher.group(2);
            if (taglibValue.contains("\\\"") || taglibValue.contains("'") && taglibValue.contains("\"")) {
                if (variableName.startsWith("taglib") || StringUtil.count(content, variableName) != 2 || !nextTag.contains("=\"<%= " + variableName + " %>\"")) continue;
                this.addMessage(fileName, "Variable '" + variableName + "' should start with 'taglib'", this.getLineCount(content, matcher.start()));
                continue;
            }
            if (!variableName.startsWith("taglib")) continue;
            if (!nextTag.contains("=\"<%= " + variableName + " %>\"")) {
                this.addMessage(fileName, "No need to specify taglib variable '" + variableName + "'", this.getLineCount(content, matcher.start()));
                continue;
            }
            content = StringUtil.replaceFirst(content, variableName, taglibValue, matcher.start(4));
            content = StringUtil.replaceFirst(content, matcher.group(1), "", matcher.start());
            return content;
        }
        return content;
    }
}

