/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaLogClassNameCheck
extends BaseFileCheck {
    private final Pattern _logPattern = Pattern.compile("\n\tprivate static final Log _log = LogFactoryUtil.getLog\\(\n*\t*(.+)\\.class\\)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = this._logPattern.matcher(content);
        if (matcher.find()) {
            String className = JavaSourceUtil.getClassName(fileName);
            String logClassName = matcher.group(1);
            if (!logClassName.equals(className)) {
                content = StringUtil.replaceLast(content, logClassName + ".class)", className + ".class)");
            }
        }
        return content;
    }
}

