/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;

public class PropertiesSourceFormatterContentCheck
extends BaseFileCheck {
    private static final String[][] _CONVERTED_KEYS = new String[][]{{"blob/master/portal-impl/src/source-formatter.properties", "blob/master/source-formatter.properties"}};
    private static final String _SOURCE_FORMATTER_PROPERTIES_URL = "https://github.com/liferay/liferay-portal/blob/master/source-formatter.properties";

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (fileName.endsWith("/source-formatter.properties")) {
            content = this._checkConvertedKeys(content);
            content = this._checkGitLiferayPortalBranch(content);
            content = this._checkPropertyKeys(content);
        }
        return content;
    }

    private String _checkConvertedKeys(String content) {
        for (String[] array : _CONVERTED_KEYS) {
            content = StringUtil.replace(content, array[0], array[1]);
        }
        return content;
    }

    private String _checkGitLiferayPortalBranch(String content) {
        if (!content.matches("(?s).*[^#]git\\.liferay\\.portal\\.branch=.*")) {
            return content;
        }
        String gitLiferayPortalBranch = "";
        String previousLine = "";
        String[] lines = StringUtil.splitLines(content);
        StringBundler sb = new StringBundler(lines.length * 2);
        for (String line : lines) {
            String s;
            String trimmedLine = StringUtil.trim(line);
            if (trimmedLine.startsWith("git.liferay.portal.branch=")) {
                gitLiferayPortalBranch = trimmedLine.substring(trimmedLine.indexOf(61) + 1);
            }
            if ((s = StringUtil.trim(previousLine)).equals("git.liferay.portal.branch=\\")) {
                gitLiferayPortalBranch = StringUtil.trim(line);
            } else if (!trimmedLine.startsWith("git.liferay.portal.branch=")) {
                sb.append(line);
                sb.append("\n");
            }
            previousLine = line;
        }
        String exclusionsComments = StringBundler.concat("##\n## Exclusions\n##\n## See ", _SOURCE_FORMATTER_PROPERTIES_URL, "\n## for available properties.\n##");
        String gitComments = "##\n## Git\n##";
        String s = StringUtil.replace(sb.toString(), new String[]{exclusionsComments, gitComments}, new String[]{"", ""});
        if (Validator.isNull(s = StringUtil.trim(s))) {
            return StringBundler.concat(exclusionsComments, "\n\n", gitComments, "\n\n", "    ", "git.liferay.portal.branch=", gitLiferayPortalBranch);
        }
        return StringBundler.concat(exclusionsComments, "\n\n", s, "\n\n", gitComments, "\n\n", "    ", "git.liferay.portal.branch=", gitLiferayPortalBranch);
    }

    private String _checkPropertyKeys(String content) {
        String[] lines = StringUtil.splitLines(content);
        StringBundler sb = new StringBundler(lines.length * 3);
        for (String line : lines) {
            int pos = line.indexOf(61);
            if (pos != -1) {
                sb.append("    ");
                sb.append(StringUtil.trim(line));
                sb.append("\n");
                continue;
            }
            sb.append(line);
            sb.append("\n");
        }
        return StringUtil.trim(sb.toString());
    }
}

