/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks.configuration;

import com.liferay.source.formatter.checks.configuration.SourceChecksSuppressions;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class SuppressionsLoader {
    public static SourceChecksSuppressions loadSuppressions(List<File> files) throws Exception {
        SourceChecksSuppressions sourceChecksSuppressions = new SourceChecksSuppressions();
        for (File file : files) {
            String suppressionsFileLocation = SuppressionsLoader._getFileLocation(file);
            String content = FileUtil.read(file);
            Document document = SourceUtil.readXML(content);
            Element rootElement = document.getRootElement();
            for (Element suppressElement : rootElement.elements("suppress")) {
                String sourceCheckName = suppressElement.attributeValue("checks");
                String fileName = suppressElement.attributeValue("files");
                sourceChecksSuppressions.addSuppression(suppressionsFileLocation, sourceCheckName, fileName);
            }
        }
        return sourceChecksSuppressions;
    }

    private static String _getFileLocation(File file) {
        String absolutePath = SourceUtil.getAbsolutePath(file);
        int pos = absolutePath.lastIndexOf(47);
        return absolutePath.substring(0, pos + 1);
    }
}

