/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.orm.hibernate.DialectImpl;
import com.liferay.portal.dao.orm.hibernate.MariaDBDialect;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactory;
import com.liferay.portal.kernel.dao.db.DBManager;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import java.util.Set;
import javax.sql.DataSource;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.Oracle9Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.Sybase11Dialect;
import org.hibernate.dialect.SybaseASE15Dialect;
import org.hibernate.dialect.SybaseAnywhereDialect;
import org.hibernate.dialect.SybaseDialect;

@DoPrivileged
public class DBManagerImpl
implements DBManager {
    private static final Log _log = LogFactoryUtil.getLog(DBManagerImpl.class);
    private DB _db;
    private final EnumMap<DBType, DBFactory> _dbFactories = new EnumMap(DBType.class);

    public DBManagerImpl() {
        ServiceLoader<DBFactory> serviceLoader = ServiceLoader.load(DBFactory.class, DBManagerImpl.class.getClassLoader());
        for (DBFactory dbFactory : serviceLoader) {
            this._dbFactories.put(dbFactory.getDBType(), dbFactory);
        }
    }

    public DB getDB() {
        if (this._db == null) {
            try {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Using dialect " + PropsValues.HIBERNATE_DIALECT));
                }
                Dialect dialect = (Dialect)InstanceFactory.newInstance((String)PropsValues.HIBERNATE_DIALECT);
                this.setDB(this.getDB(this.getDBType(dialect), InfrastructureUtil.getDataSource()));
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return this._db;
    }

    public DB getDB(DBType dbType, DataSource dataSource) {
        DBFactory dbCreator;
        int dbMajorVersion = 0;
        int dbMinorVersion = 0;
        if (dataSource != null) {
            try (Connection connection = dataSource.getConnection();){
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                dbMajorVersion = databaseMetaData.getDatabaseMajorVersion();
                dbMinorVersion = databaseMetaData.getDatabaseMinorVersion();
            }
            catch (SQLException sqle) {
                return (DB)ReflectionUtil.throwException((Throwable)sqle);
            }
        }
        if ((dbCreator = this._dbFactories.get(dbType)) == null) {
            throw new IllegalArgumentException("Unsupported database type " + dbType);
        }
        return dbCreator.create(dbMajorVersion, dbMinorVersion);
    }

    public DBType getDBType(Object dialect) {
        if (dialect instanceof DialectImpl) {
            DialectImpl dialectImpl = (DialectImpl)dialect;
            dialect = dialectImpl.getWrappedDialect();
        }
        if (dialect instanceof DB2Dialect) {
            return DBType.DB2;
        }
        if (dialect instanceof HSQLDialect) {
            return DBType.HYPERSONIC;
        }
        if (dialect instanceof MariaDBDialect) {
            return DBType.MARIADB;
        }
        if (dialect instanceof MySQLDialect) {
            return DBType.MYSQL;
        }
        if (dialect instanceof Oracle8iDialect || dialect instanceof Oracle9Dialect) {
            return DBType.ORACLE;
        }
        if (dialect instanceof PostgreSQLDialect) {
            return DBType.POSTGRESQL;
        }
        if (dialect instanceof SQLServerDialect) {
            return DBType.SQLSERVER;
        }
        if (dialect instanceof Sybase11Dialect || dialect instanceof SybaseAnywhereDialect || dialect instanceof SybaseASE15Dialect || dialect instanceof SybaseDialect) {
            return DBType.SYBASE;
        }
        throw new IllegalArgumentException("Unknown dialect type " + dialect);
    }

    public Set<DBType> getDBTypes() {
        return new LinkedHashSet<DBType>(this._dbFactories.keySet());
    }

    public void setDB(DB db) {
        this._db = db;
        if (_log.isDebugEnabled()) {
            Class<?> clazz = this._db.getClass();
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Using DB implementation ", clazz.getName(), " for ", String.valueOf(db.getDBType())}));
        }
    }
}

