/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.aop;

import com.liferay.portal.kernel.dao.jdbc.aop.DynamicDataSourceTargetSource;
import com.liferay.portal.kernel.dao.jdbc.aop.MasterDataSource;
import com.liferay.portal.kernel.dao.jdbc.aop.Operation;
import com.liferay.portal.spring.aop.ChainableMethodAdvice;
import com.liferay.portal.spring.aop.ServiceBeanAopCacheManager;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;

public class DynamicDataSourceAdvice
extends ChainableMethodAdvice {
    private static final MasterDataSource _nullMasterDataSource = new MasterDataSource(){

        public Class<? extends MasterDataSource> annotationType() {
            return MasterDataSource.class;
        }
    };
    private DynamicDataSourceTargetSource _dynamicDataSourceTargetSource;
    private TransactionAttributeSource _transactionAttributeSource;

    @Override
    public Object before(MethodInvocation methodInvocation) throws Throwable {
        TransactionAttribute transactionAttribute;
        Operation operation = Operation.WRITE;
        Object targetBean = methodInvocation.getThis();
        Class<?> targetClass = targetBean.getClass();
        Method targetMethod = methodInvocation.getMethod();
        MasterDataSource masterDataSource = ServiceBeanAopCacheManager.getAnnotation(methodInvocation, MasterDataSource.class, _nullMasterDataSource);
        if (masterDataSource == _nullMasterDataSource && (transactionAttribute = this._transactionAttributeSource.getTransactionAttribute(targetMethod, targetClass)) != null && transactionAttribute.isReadOnly()) {
            operation = Operation.READ;
        }
        this._dynamicDataSourceTargetSource.setOperation(operation);
        String targetClassName = targetClass.getName();
        this._dynamicDataSourceTargetSource.pushMethod(targetClassName.concat(".").concat(targetMethod.getName()));
        return null;
    }

    @Override
    public void duringFinally(MethodInvocation methodInvocation) {
        this._dynamicDataSourceTargetSource.popMethod();
    }

    public void setDynamicDataSourceTargetSource(DynamicDataSourceTargetSource dynamicDataSourceTargetSource) {
        this._dynamicDataSourceTargetSource = dynamicDataSourceTargetSource;
    }

    public void setTransactionAttributeSource(TransactionAttributeSource transactionAttributeSource) {
        this._transactionAttributeSource = transactionAttributeSource;
    }

    @Override
    protected void setServiceBeanAopCacheManager(ServiceBeanAopCacheManager serviceBeanAopCacheManager) {
        if (this.serviceBeanAopCacheManager != null) {
            return;
        }
        this.serviceBeanAopCacheManager = serviceBeanAopCacheManager;
        serviceBeanAopCacheManager.registerAnnotationChainableMethodAdvice(MasterDataSource.class, null);
    }
}

