/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.sql.transformer;

import com.liferay.portal.dao.sql.transformer.BaseSQLTransformerLogic;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.function.Function;
import java.util.regex.Matcher;

public class OracleSQLTransformerLogic
extends BaseSQLTransformerLogic {
    public OracleSQLTransformerLogic(DB db) {
        super(db);
        this.setFunctions(this.getBooleanFunction(), this.getCastClobTextFunction(), this.getCastLongFunction(), this.getCastTextFunction(), this.getIntegerDivisionFunction(), this.getNullDateFunction(), this._getEscapeFunction(), this._getNotEqualsBlankStringFunction());
    }

    @Override
    protected String replaceCastClobText(Matcher matcher) {
        return matcher.replaceAll("DBMS_LOB.SUBSTR($1, 4000, 1)");
    }

    @Override
    protected String replaceCastText(Matcher matcher) {
        return matcher.replaceAll("CAST($1 AS VARCHAR(4000))");
    }

    @Override
    protected String replaceIntegerDivision(Matcher matcher) {
        return matcher.replaceAll("TRUNC($1 / $2)");
    }

    private Function<String, String> _getEscapeFunction() {
        return sql -> StringUtil.replace((String)sql, (String)"LIKE ?", (String)"LIKE ? ESCAPE '\\'");
    }

    private Function<String, String> _getNotEqualsBlankStringFunction() {
        return sql -> StringUtil.replace((String)sql, (String)" != ''", (String)" IS NOT NULL");
    }
}

