/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.plugin;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.plugin.PluginPackageNameAndContextComparator;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.plugin.PluginPackageImpl;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LocalPluginPackageRepository {
    private static final Log _log = LogFactoryUtil.getLog(LocalPluginPackageRepository.class);
    private final Map<String, PluginPackage> _pendingPackages = new HashMap<String, PluginPackage>();
    private final Map<String, PluginPackage> _pluginPackages = new HashMap<String, PluginPackage>();

    public void addPluginPackage(PluginPackage pluginPackage) {
        if (pluginPackage.getContext() == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Plugin package cannot be registered because it does not have an installation context");
            }
            return;
        }
        this._pendingPackages.remove(pluginPackage.getContext());
        this._pendingPackages.remove(pluginPackage.getModuleId());
        this._pluginPackages.remove(pluginPackage.getContext());
        this._pluginPackages.put(pluginPackage.getContext(), pluginPackage);
    }

    public PluginPackage getInstallingPluginPackage(String context) {
        return this._pendingPackages.get(context);
    }

    public PluginPackage getLatestPluginPackage(String groupId, String artifactId) {
        PluginPackage latestPluginPackage = null;
        for (PluginPackage pluginPackage : this._pluginPackages.values()) {
            if (!pluginPackage.getGroupId().equals(groupId) || !pluginPackage.getArtifactId().equals(artifactId) || latestPluginPackage != null && !pluginPackage.isLaterVersionThan(latestPluginPackage)) continue;
            latestPluginPackage = pluginPackage;
        }
        return latestPluginPackage;
    }

    public PluginPackage getPluginPackage(String context) {
        return this._pluginPackages.get(context);
    }

    public List<PluginPackage> getPluginPackages() {
        return new ArrayList<PluginPackage>(this._pluginPackages.values());
    }

    public List<PluginPackage> getPluginPackages(String groupId, String artifactId) {
        ArrayList<PluginPackage> pluginPackages = new ArrayList<PluginPackage>();
        for (PluginPackage pluginPackage : this._pluginPackages.values()) {
            if (!pluginPackage.getGroupId().equals(groupId) || !pluginPackage.getArtifactId().equals(artifactId)) continue;
            pluginPackages.add(pluginPackage);
        }
        return pluginPackages;
    }

    public List<PluginPackage> getSortedPluginPackages() {
        ArrayList<PluginPackage> pluginPackages = new ArrayList<PluginPackage>();
        pluginPackages.addAll(this._pluginPackages.values());
        return ListUtil.sort(pluginPackages, (Comparator)new PluginPackageNameAndContextComparator());
    }

    public void registerPluginPackageInstallation(PluginPackage pluginPackage) {
        String key;
        PluginPackage previousPluginPackage;
        if (pluginPackage.getContext() != null && (previousPluginPackage = this._pluginPackages.get(pluginPackage.getContext())) == null) {
            this.addPluginPackage(pluginPackage);
        }
        if ((key = pluginPackage.getContext()) == null) {
            key = pluginPackage.getModuleId();
        }
        this._pendingPackages.put(key, pluginPackage);
    }

    public void registerPluginPackageInstallation(String deploymentContext) {
        PluginPackage pluginPackage = this.getPluginPackage(deploymentContext);
        if (pluginPackage == null) {
            String moduleId = StringBundler.concat((String[])new String[]{deploymentContext, "/", deploymentContext, "/", "unknown", "/", "war"});
            pluginPackage = new PluginPackageImpl(moduleId);
            pluginPackage.setName(deploymentContext);
            pluginPackage.setContext(deploymentContext);
        }
        this.registerPluginPackageInstallation(pluginPackage);
    }

    public void removePluginPackage(PluginPackage pluginPackage) throws PortalException {
        this._pluginPackages.remove(pluginPackage.getContext());
        Indexer indexer = IndexerRegistryUtil.getIndexer(PluginPackage.class);
        indexer.delete((Object)pluginPackage);
    }

    public void removePluginPackage(String context) {
        this._pluginPackages.remove(context);
    }

    public void unregisterPluginPackageInstallation(String context) {
        this._pluginPackages.remove(context);
        this._pendingPackages.remove(context);
    }
}

