/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.resiliency.spi.agent;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.resiliency.PortalResiliencyException;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import com.liferay.portal.kernel.resiliency.spi.SPIConfiguration;
import com.liferay.portal.kernel.resiliency.spi.agent.AcceptorServlet;
import com.liferay.portal.kernel.resiliency.spi.agent.SPIAgent;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.ReadOnlyServletResponse;
import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.resiliency.spi.agent.SPIAgentRequest;
import com.liferay.portal.resiliency.spi.agent.SPIAgentResponse;
import com.liferay.portal.util.PropsValues;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpClientSPIAgent
implements SPIAgent {
    protected static final String MAPPING_PATTERN = "/acceptor";
    protected static final String SPI_AGENT_CONTEXT_PATH = "/spi_agent";
    protected final byte[] httpServletRequestContent;
    protected final RegistrationReference registrationReference;
    protected final SocketAddress socketAddress;
    protected final BlockingQueue<Socket> socketBlockingQueue;
    private static final Log _log = LogFactoryUtil.getLog(HttpClientSPIAgent.class);

    public HttpClientSPIAgent(SPIConfiguration spiConfiguration, RegistrationReference registrationReference) throws UnknownHostException {
        this.registrationReference = registrationReference;
        this.socketAddress = new InetSocketAddress(InetAddressUtil.getLoopbackInetAddress(), spiConfiguration.getConnectorPort());
        this.socketBlockingQueue = new ArrayBlockingQueue<Socket>(PropsValues.PORTAL_RESILIENCY_SPI_AGENT_CLIENT_POOL_MAX_SIZE);
        StringBundler sb = new StringBundler(7);
        sb.append("POST ");
        sb.append(SPI_AGENT_CONTEXT_PATH);
        sb.append(MAPPING_PATTERN);
        sb.append(" HTTP/1.1\r\nHost: localhost:");
        sb.append(spiConfiguration.getConnectorPort());
        sb.append("\r\n");
        sb.append("Content-Length: 8\r\n\r\n");
        String httpServletRequestContentString = sb.toString();
        this.httpServletRequestContent = httpServletRequestContentString.getBytes(Charset.forName("US-ASCII"));
    }

    public void destroy() {
        Iterator iterator = this.socketBlockingQueue.iterator();
        while (iterator.hasNext()) {
            Socket socket = (Socket)iterator.next();
            iterator.remove();
            try {
                socket.close();
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)ioe, (Throwable)ioe);
            }
        }
    }

    public void init(SPI spi) throws PortalResiliencyException {
        try {
            SPIConfiguration spiConfiguration = spi.getSPIConfiguration();
            spi.addServlet(SPI_AGENT_CONTEXT_PATH, spiConfiguration.getBaseDir(), MAPPING_PATTERN, AcceptorServlet.class.getName());
        }
        catch (Exception e) {
            throw new PortalResiliencyException((Throwable)e);
        }
    }

    public HttpServletRequest prepareRequest(HttpServletRequest request) throws IOException {
        SPIAgentRequest spiAgentRequest = (SPIAgentRequest)SPIAgentRequest.readFrom((InputStream)request.getInputStream());
        HttpServletRequest spiAgentHttpServletRequest = spiAgentRequest.populateRequest(request);
        spiAgentHttpServletRequest.setAttribute("SPI_AGENT_REQUEST", (Object)spiAgentRequest);
        return spiAgentHttpServletRequest;
    }

    public HttpServletResponse prepareResponse(HttpServletRequest request, HttpServletResponse response) {
        BufferCacheServletResponse spiAgentHttpServletResponse = new BufferCacheServletResponse((HttpServletResponse)new ReadOnlyServletResponse(response));
        request.setAttribute("SPI_AGENT_ORIGINAL_RESPONSE", (Object)response);
        Portlet portlet = (Portlet)request.getAttribute("SPI_AGENT_PORTLET");
        request.setAttribute("SPI_AGENT_RESPONSE", (Object)new SPIAgentResponse(portlet.getContextName()));
        return spiAgentHttpServletResponse;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws PortalResiliencyException {
        Socket socket = null;
        try {
            socket = this.borrowSocket();
            SPIAgentRequest spiAgentRequest = new SPIAgentRequest(request);
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(this.httpServletRequestContent);
            spiAgentRequest.writeTo(this.registrationReference, outputStream);
            InputStream inputStream = socket.getInputStream();
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            boolean forceCloseSocket = this.consumeHttpResponseHead(dataInputStream);
            SPIAgentResponse spiAgentResponse = (SPIAgentResponse)SPIAgentResponse.readFrom(dataInputStream);
            spiAgentResponse.populate(request, response);
            this.returnSocket(socket, forceCloseSocket);
            socket = null;
        }
        catch (IOException ioe) {
            throw new PortalResiliencyException((Throwable)ioe);
        }
        finally {
            block11: {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException ioe) {
                        if (!_log.isWarnEnabled()) break block11;
                        _log.warn((Object)ioe, (Throwable)ioe);
                    }
                }
            }
        }
    }

    public void transferResponse(HttpServletRequest request, HttpServletResponse response, Exception exception) throws IOException {
        SPIAgentRequest spiAgentRequest = (SPIAgentRequest)request.getAttribute("SPI_AGENT_REQUEST");
        request.removeAttribute("SPI_AGENT_REQUEST");
        File requestBodyFile = spiAgentRequest.requestBodyFile;
        if (requestBodyFile != null && !requestBodyFile.delete()) {
            requestBodyFile.deleteOnExit();
        }
        SPIAgentResponse spiAgentResponse = (SPIAgentResponse)request.getAttribute("SPI_AGENT_RESPONSE");
        request.removeAttribute("SPI_AGENT_RESPONSE");
        if (exception != null) {
            spiAgentResponse.setException(exception);
        } else {
            BufferCacheServletResponse bufferCacheServletResponse = (BufferCacheServletResponse)response;
            spiAgentResponse.captureResponse(request, bufferCacheServletResponse);
        }
        HttpServletResponse originalResponse = (HttpServletResponse)request.getAttribute("SPI_AGENT_ORIGINAL_RESPONSE");
        request.removeAttribute("SPI_AGENT_ORIGINAL_RESPONSE");
        originalResponse.setContentLength(8);
        spiAgentResponse.writeTo(this.registrationReference, (OutputStream)originalResponse.getOutputStream());
    }

    protected Socket borrowSocket() throws IOException {
        Socket socket = (Socket)this.socketBlockingQueue.poll();
        if (socket != null && (socket.isClosed() || !socket.isConnected() || socket.isInputShutdown() || socket.isOutputShutdown())) {
            block4: {
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)ioe, (Throwable)ioe);
                }
            }
            socket = null;
        }
        if (socket == null) {
            socket = new Socket();
            socket.connect(this.socketAddress);
        }
        return socket;
    }

    protected boolean consumeHttpResponseHead(DataInput dataInput) throws IOException {
        String statusLine = dataInput.readLine();
        if (!statusLine.equals("HTTP/1.1 200 OK")) {
            throw new IOException("Error status line: " + statusLine);
        }
        boolean forceCloseSocket = false;
        String line = null;
        while ((line = dataInput.readLine()) != null && line.length() > 0) {
            String[] headerKeyValuePair = StringUtil.split((String)line, (char)':');
            String headerName = headerKeyValuePair[0].trim();
            if (!(headerName = StringUtil.toLowerCase((String)headerName)).equals("connection")) continue;
            String headerValue = headerKeyValuePair[1].trim();
            if (!(headerValue = StringUtil.toLowerCase((String)headerValue)).equals("close")) continue;
            forceCloseSocket = true;
        }
        return forceCloseSocket;
    }

    protected void returnSocket(Socket socket, boolean forceCloseSocket) {
        block4: {
            boolean pooled = false;
            if (!forceCloseSocket && socket.isConnected() && !socket.isInputShutdown() && !socket.isOutputShutdown()) {
                pooled = this.socketBlockingQueue.offer(socket);
            }
            if (!pooled) {
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)ioe, (Throwable)ioe);
                }
            }
        }
    }
}

