/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourceBlockPermissionsContainer;
import com.liferay.portal.kernel.model.ResourceTypePermission;
import com.liferay.portal.service.base.ResourceTypePermissionLocalServiceBaseImpl;
import java.util.List;

public class ResourceTypePermissionLocalServiceImpl
extends ResourceTypePermissionLocalServiceBaseImpl {
    public ResourceTypePermission fetchResourceTypePermission(long companyId, long groupId, String name, long roleId) {
        return this.resourceTypePermissionPersistence.fetchByC_G_N_R(companyId, groupId, name, roleId);
    }

    public long getCompanyScopeActionIds(long companyId, String name, long roleId) {
        return this.getGroupScopeActionIds(companyId, 0L, name, roleId);
    }

    public long getGroupScopeActionIds(long companyId, long groupId, String name, long roleId) {
        ResourceTypePermission resourceTypePermission = this.resourceTypePermissionPersistence.fetchByC_G_N_R(companyId, groupId, name, roleId);
        if (resourceTypePermission == null) {
            return 0L;
        }
        return resourceTypePermission.getActionIds();
    }

    public List<ResourceTypePermission> getGroupScopeResourceTypePermissions(long companyId, String name, long roleId) {
        return this.resourceTypePermissionFinder.findByGroupScopeC_N_R(companyId, name, roleId);
    }

    public ResourceBlockPermissionsContainer getResourceBlockPermissionsContainer(long companyId, long groupId, String name) {
        List resourceTypePermissions = this.resourceTypePermissionFinder.findByEitherScopeC_G_N(companyId, groupId, name);
        ResourceBlockPermissionsContainer resourceBlockPermissionContainer = new ResourceBlockPermissionsContainer();
        for (ResourceTypePermission resourceTypePermission : resourceTypePermissions) {
            resourceBlockPermissionContainer.setPermissions(resourceTypePermission.getRoleId(), resourceTypePermission.getActionIds());
        }
        return resourceBlockPermissionContainer;
    }

    public List<ResourceTypePermission> getRoleResourceTypePermissions(long roleId) {
        return this.resourceTypePermissionPersistence.findByRoleId(roleId);
    }

    public boolean hasCompanyScopePermission(long companyId, String name, long roleId, String actionId) throws PortalException {
        return this.hasGroupScopePermission(companyId, 0L, name, roleId, actionId);
    }

    public boolean hasEitherScopePermission(long companyId, String name, long roleId, String actionId) throws PortalException {
        ResourceAction resourceAction = this.resourceActionLocalService.getResourceAction(name, actionId);
        List resourceTypePermissions = this.resourceTypePermissionPersistence.findByC_N_R(companyId, name, roleId);
        for (ResourceTypePermission resourceTypePermission : resourceTypePermissions) {
            long bitwiseValue;
            long actionIdsLong = resourceTypePermission.getActionIds();
            if ((actionIdsLong & (bitwiseValue = resourceAction.getBitwiseValue())) != bitwiseValue) continue;
            return true;
        }
        return false;
    }

    public boolean hasGroupScopePermission(long companyId, long groupId, String name, long roleId, String actionId) throws PortalException {
        long bitwiseValue;
        ResourceAction resourceAction = this.resourceActionLocalService.getResourceAction(name, actionId);
        ResourceTypePermission resourceTypePermission = this.resourceTypePermissionPersistence.findByC_G_N_R(companyId, groupId, name, roleId);
        long actionIdsLong = resourceTypePermission.getActionIds();
        return (actionIdsLong & (bitwiseValue = resourceAction.getBitwiseValue())) == bitwiseValue;
    }

    public void updateCompanyScopeResourceTypePermissions(long companyId, String name, long roleId, long actionIdsLong, long operator) {
        this.updateGroupScopeResourceTypePermissions(companyId, 0L, name, roleId, actionIdsLong, operator);
    }

    public void updateGroupScopeResourceTypePermissions(long companyId, long groupId, String name, long roleId, long actionIdsLong, long operator) {
        ResourceTypePermission resourceTypePermission = this.resourceTypePermissionPersistence.fetchByC_G_N_R(companyId, groupId, name, roleId);
        if (resourceTypePermission == null) {
            if (actionIdsLong == 0L) {
                return;
            }
            long resourceTypePermissionId = this.counterLocalService.increment();
            resourceTypePermission = this.resourceTypePermissionPersistence.create(resourceTypePermissionId);
            resourceTypePermission.setCompanyId(companyId);
            resourceTypePermission.setGroupId(groupId);
            resourceTypePermission.setName(name);
            resourceTypePermission.setRoleId(roleId);
        }
        if (operator == 1L) {
            actionIdsLong |= resourceTypePermission.getActionIds();
        } else if (operator == 2L) {
            actionIdsLong = resourceTypePermission.getActionIds() & (actionIdsLong ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (actionIdsLong == 0L) {
            this.deleteResourceTypePermission(resourceTypePermission);
        } else {
            resourceTypePermission.setActionIds(actionIdsLong);
            this.updateResourceTypePermission(resourceTypePermission);
        }
    }
}

