/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.virtualhost;

import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.servlet.I18nServlet;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webserver.WebServerServlet;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class VirtualHostFilter
extends BasePortalFilter {
    private static final String _PATH_DOCUMENTS = "/documents/";
    private static final String _PATH_MODULE_SLASH = "/o/";
    private static final String _PRIVATE_GROUP_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING;
    private static final String _PRIVATE_GROUP_SERVLET_MAPPING_SLASH = _PRIVATE_GROUP_SERVLET_MAPPING + "/";
    private static final String _PRIVATE_USER_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING;
    private static final String _PRIVATE_USER_SERVLET_MAPPING_SLASH = _PRIVATE_USER_SERVLET_MAPPING + "/";
    private static final String _PUBLIC_GROUP_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING;
    private static final String _PUBLIC_GROUP_SERVLET_MAPPING_SLASH = _PUBLIC_GROUP_SERVLET_MAPPING + "/";
    private static final Log _log = LogFactoryUtil.getLog(VirtualHostFilter.class);
    private String _contextPath;
    private ServletContext _servletContext;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._servletContext = filterConfig.getServletContext();
        String contextPath = PortalUtil.getPathContext();
        String proxyPath = PortalUtil.getPathProxy();
        if (!contextPath.isEmpty() && !proxyPath.isEmpty() && contextPath.startsWith(proxyPath)) {
            contextPath = contextPath.substring(proxyPath.length());
        }
        this._contextPath = contextPath;
    }

    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        String uri = request.getRequestURI();
        for (String extension : PropsValues.VIRTUAL_HOSTS_IGNORE_EXTENSIONS) {
            if (!uri.endsWith(extension)) continue;
            return false;
        }
        return true;
    }

    protected boolean isDocumentFriendlyURL(HttpServletRequest request, long groupId, String friendlyURL) throws PortalException {
        if (friendlyURL.startsWith(_PATH_DOCUMENTS) && WebServerServlet.hasFiles(request)) {
            String path = HttpUtil.fixPath((String)request.getPathInfo());
            String[] pathArray = StringUtil.split((String)path, (char)'/');
            if (pathArray.length == 2) {
                try {
                    LayoutLocalServiceUtil.getFriendlyURLLayout((long)groupId, (boolean)false, (String)friendlyURL);
                }
                catch (NoSuchLayoutException nsle) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)nsle, (Throwable)nsle);
                    }
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidFriendlyURL(String friendlyURL) {
        if (PortalInstances.isVirtualHostsIgnorePath(friendlyURL = StringUtil.toLowerCase((String)friendlyURL)) || friendlyURL.startsWith(_PATH_MODULE_SLASH) || friendlyURL.startsWith(_PRIVATE_GROUP_SERVLET_MAPPING_SLASH) || friendlyURL.startsWith(_PRIVATE_USER_SERVLET_MAPPING_SLASH) || friendlyURL.startsWith(_PUBLIC_GROUP_SERVLET_MAPPING_SLASH)) {
            return false;
        }
        if (LayoutImpl.hasFriendlyURLKeyword(friendlyURL)) {
            return false;
        }
        int code = LayoutImpl.validateFriendlyURL(friendlyURL, false);
        return code <= -1 || code == 2;
    }

    @Deprecated
    protected boolean isValidRequestURL(StringBuffer requestURL) {
        if (requestURL == null) {
            return false;
        }
        String url = requestURL.toString();
        for (String extension : PropsValues.VIRTUAL_HOSTS_IGNORE_EXTENSIONS) {
            if (!url.endsWith(extension)) continue;
            return false;
        }
        return true;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        String i18nLanguageId;
        int pos;
        String originalFriendlyURL;
        long companyId = PortalInstances.getCompanyId(request);
        String friendlyURL = originalFriendlyURL = request.getRequestURI();
        if (!(friendlyURL = StringUtil.replace((String)friendlyURL, (String)"//", (String)"/")).equals("/") && !this._contextPath.isEmpty() && friendlyURL.length() > this._contextPath.length() && friendlyURL.startsWith(this._contextPath) && friendlyURL.charAt(this._contextPath.length()) == '/') {
            friendlyURL = friendlyURL.substring(this._contextPath.length());
        }
        if ((pos = friendlyURL.indexOf(59)) != -1) {
            friendlyURL = friendlyURL.substring(0, pos);
        }
        if ((i18nLanguageId = this._findLanguageId(friendlyURL)) != null) {
            friendlyURL = friendlyURL.substring(i18nLanguageId.length());
        }
        int widgetServletMappingPos = 0;
        if (friendlyURL.contains(PropsValues.WIDGET_SERVLET_MAPPING)) {
            friendlyURL = StringUtil.replaceFirst((String)friendlyURL, (String)PropsValues.WIDGET_SERVLET_MAPPING, (String)"");
            widgetServletMappingPos = PropsValues.WIDGET_SERVLET_MAPPING.length();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Friendly URL " + friendlyURL));
        }
        if (!friendlyURL.equals("/") && !this.isValidFriendlyURL(friendlyURL)) {
            int offset;
            _log.debug((Object)"Friendly URL is not valid");
            if (i18nLanguageId != null && !originalFriendlyURL.regionMatches(offset = originalFriendlyURL.length() - friendlyURL.length() - (i18nLanguageId.length() + widgetServletMappingPos), i18nLanguageId, 0, i18nLanguageId.length())) {
                String forwardURL = originalFriendlyURL;
                if (offset > 0) {
                    String prefix = originalFriendlyURL.substring(0, offset);
                    forwardURL = prefix.concat(i18nLanguageId);
                } else {
                    forwardURL = i18nLanguageId;
                }
                forwardURL = forwardURL.concat(friendlyURL);
                forwardURL = this._appendQueryString(request, forwardURL);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Forward to " + forwardURL));
                }
                RequestDispatcher requestDispatcher = this._servletContext.getRequestDispatcher(forwardURL);
                requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            this.processFilter(VirtualHostFilter.class.getName(), request, response, filterChain);
            return;
        }
        LayoutSet layoutSet = (LayoutSet)request.getAttribute("VIRTUAL_HOST_LAYOUT_SET");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Layout set " + layoutSet));
        }
        if (layoutSet == null) {
            this.processFilter(VirtualHostFilter.class.getName(), request, response, filterChain);
            return;
        }
        try {
            Map parameterMap = request.getParameterMap();
            String parameters = "";
            if (!parameterMap.isEmpty()) {
                parameters = HttpUtil.parameterMapToString((Map)parameterMap);
            }
            LastPath lastPath = new LastPath(this._contextPath, friendlyURL, parameters);
            request.setAttribute("LAST_PATH", (Object)lastPath);
            StringBundler forwardURL = new StringBundler(5);
            if (i18nLanguageId != null) {
                forwardURL.append(i18nLanguageId);
            }
            if (originalFriendlyURL.startsWith(PropsValues.WIDGET_SERVLET_MAPPING)) {
                forwardURL.append(PropsValues.WIDGET_SERVLET_MAPPING);
                friendlyURL = StringUtil.replaceFirst((String)friendlyURL, (String)PropsValues.WIDGET_SERVLET_MAPPING, (String)"");
            }
            if (friendlyURL.equals("/") || PortalUtil.getPlidFromFriendlyURL((long)companyId, (String)friendlyURL) <= 0L) {
                Group group = layoutSet.getGroup();
                if (this.isDocumentFriendlyURL(request, group.getGroupId(), friendlyURL)) {
                    this.processFilter(VirtualHostFilter.class.getName(), request, response, filterChain);
                    return;
                }
                if (group.isGuest() && friendlyURL.equals("/") && !layoutSet.isPrivateLayout()) {
                    String homeURL = PortalUtil.getRelativeHomeURL((HttpServletRequest)request);
                    if (Validator.isNotNull((String)homeURL)) {
                        friendlyURL = homeURL;
                    }
                } else {
                    if (layoutSet.isPrivateLayout()) {
                        if (group.isUser()) {
                            forwardURL.append(_PRIVATE_USER_SERVLET_MAPPING);
                        } else {
                            forwardURL.append(_PRIVATE_GROUP_SERVLET_MAPPING);
                        }
                    } else {
                        forwardURL.append(_PUBLIC_GROUP_SERVLET_MAPPING);
                    }
                    forwardURL.append(group.getFriendlyURL());
                }
            }
            String forwardURLString = friendlyURL;
            if (forwardURL.index() > 0) {
                forwardURL.append(friendlyURL);
                forwardURLString = forwardURL.toString();
            }
            forwardURLString = this._appendQueryString(request, forwardURLString);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Forward to " + forwardURLString));
            }
            RequestDispatcher requestDispatcher = this._servletContext.getRequestDispatcher(forwardURLString);
            requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            this.processFilter(VirtualHostFilter.class.getName(), request, response, filterChain);
        }
    }

    private String _appendQueryString(HttpServletRequest request, String path) {
        String queryString = request.getQueryString();
        if (Validator.isNull((String)queryString)) {
            queryString = (String)request.getAttribute("javax.servlet.forward.query_string");
        }
        if (Validator.isNotNull((String)queryString)) {
            return path.concat("?").concat(queryString);
        }
        return path;
    }

    private String _findLanguageId(String friendlyURL) {
        if (friendlyURL.isEmpty() || friendlyURL.charAt(0) != '/') {
            return null;
        }
        String lowerCaseLanguageId = friendlyURL;
        int index = friendlyURL.indexOf(47, 1);
        if (index != -1) {
            lowerCaseLanguageId = friendlyURL.substring(0, index);
        }
        lowerCaseLanguageId = StringUtil.toLowerCase((String)lowerCaseLanguageId);
        Map<String, String> languageIds = I18nServlet.getLanguageIdsMap();
        String languageId = languageIds.get(lowerCaseLanguageId);
        if (languageId == null) {
            return null;
        }
        return languageId;
    }
}

