/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.upgrade.v6_1_0.util.GroupTable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeGroup
extends UpgradeProcess {
    private static final String _ORGANIZATION_NAME_DELIMETER = " LFR_ORGANIZATION ";

    protected void doUpgrade() throws Exception {
        this.alter(GroupTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterColumnType((UpgradeProcess)this, "name", "VARCHAR(150) null")});
        this.updateName();
        this.updateSite();
    }

    /*
     * Exception decompiling
     */
    protected long getClassNameId(String className) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void updateName() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long organizationClassNameId = this.getClassNameId("com.liferay.portal.model.Organization");
            StringBundler sb = new StringBundler(4);
            sb.append("select Group_.groupId, Group_.classPK, ");
            sb.append("Organization_.name from Group_ inner join ");
            sb.append("Organization_ on Organization_.organizationId = ");
            sb.append("Group_.classPK where classNameId = ?");
            try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());){
                ps.setLong(1, organizationClassNameId);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        long groupId = rs.getLong("groupId");
                        long classPK = rs.getLong("classPK");
                        String name = rs.getString("name");
                        this.updateName(groupId, classPK, name);
                    }
                }
            }
        }
    }

    protected void updateName(long groupId, long classPK, String name) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update Group_ set name = ? where groupId = ?");){
            StringBundler sb = new StringBundler(3);
            sb.append(classPK);
            sb.append(_ORGANIZATION_NAME_DELIMETER);
            sb.append(name);
            ps.setString(1, sb.toString());
            ps.setLong(2, groupId);
            ps.executeUpdate();
        }
    }

    protected void updateSite() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long groupClassNameId = this.getClassNameId("com.liferay.portal.model.Group");
            this.runSQL("update Group_ set site = TRUE where classNameId = " + groupClassNameId);
            long organizationClassNameId = this.getClassNameId("com.liferay.portal.model.Organization");
            try (PreparedStatement ps = this.connection.prepareStatement("select distinct Group_.groupId from Group_ inner join Layout on Layout.groupId = Group_.groupId where classNameId = ?");){
                ps.setLong(1, organizationClassNameId);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        long groupId = rs.getLong("groupId");
                        this.runSQL("update Group_ set site = TRUE where groupId = " + groupId);
                    }
                }
            }
        }
    }
}

