/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

public class JarUtil {
    private static final Log _log = LogFactoryUtil.getLog(JarUtil.class);
    private static final Method _addURLMethod;

    public static Path downloadAndInstallJar(URL url, String libPath, String name) throws Exception {
        block18: {
            String urlString;
            String protocol = url.getProtocol();
            if (PortalRunMode.isTestMode() && (protocol.equals("http") || protocol.equals("https")) && !(urlString = url.toExternalForm()).contains("mirrors")) {
                try {
                    InetAddress.getAllByName("mirrors");
                    String newURLString = StringUtil.replace((String)urlString, (String)"://", (String)"://mirrors/");
                    url = new URL(newURLString);
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)StringBundler.concat((String[])new String[]{"Swapping URL from ", urlString, " to ", newURLString}));
                    }
                }
                catch (UnknownHostException uhe) {
                    if (!_log.isDebugEnabled()) break block18;
                    _log.debug((Object)"Unable to resolve \"mirrors\"");
                }
            }
        }
        Path path = Paths.get(libPath, name);
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((String[])new String[]{"Downloading ", String.valueOf(url), " to ", String.valueOf(path)}));
        }
        try (InputStream inputStream = url.openStream();){
            Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((String[])new String[]{"Downloaded ", String.valueOf(url), " to ", String.valueOf(path)}));
        }
        return path;
    }

    public static void downloadAndInstallJar(URL url, String libPath, String name, URLClassLoader urlClassLoader) throws Exception {
        Path path = JarUtil.downloadAndInstallJar(url, libPath, name);
        URI uri = path.toUri();
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((String[])new String[]{"Installing ", String.valueOf(path), " to ", String.valueOf(urlClassLoader)}));
        }
        _addURLMethod.invoke((Object)urlClassLoader, uri.toURL());
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((String[])new String[]{"Installed ", String.valueOf(path), " to ", String.valueOf(urlClassLoader)}));
        }
    }

    static {
        try {
            _addURLMethod = ReflectionUtil.getDeclaredMethod(URLClassLoader.class, (String)"addURL", (Class[])new Class[]{URL.class});
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

