/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.xmlrpc;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xmlrpc.Fault;
import com.liferay.portal.kernel.xmlrpc.XmlRpcException;
import com.liferay.portal.xmlrpc.XmlRpcParser;

public class FaultImpl
implements Fault {
    private final int _code;
    private final String _description;

    public FaultImpl(int code, String description) {
        this._code = code;
        this._description = description;
    }

    public int getCode() {
        return this._code;
    }

    public String getDescription() {
        return this._description;
    }

    public String toString() {
        return StringBundler.concat((String[])new String[]{"XML-RPC fault ", String.valueOf(this._code), " ", this._description});
    }

    public String toXml() throws XmlRpcException {
        StringBundler sb = new StringBundler(17);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<methodResponse>");
        sb.append("<fault>");
        sb.append("<value>");
        sb.append("<struct>");
        sb.append("<member>");
        sb.append("<name>faultCode</name>");
        sb.append(XmlRpcParser.wrapValue(this._code));
        sb.append("</member>");
        sb.append("<member>");
        sb.append("<name>faultString</name>");
        sb.append(XmlRpcParser.wrapValue(this._description));
        sb.append("</member>");
        sb.append("</struct>");
        sb.append("</value>");
        sb.append("</fault>");
        sb.append("</methodResponse>");
        return sb.toString();
    }
}

