/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.servlet.PortalSessionContext;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class RenderParametersPool {
    public static Map<String, Map<String, String[]>> clear(HttpServletRequest request, long plid) {
        if (plid <= 0L) {
            return null;
        }
        Map<Long, Map<String, Map<String, String[]>>> pool = RenderParametersPool._getRenderParametersPool(request, false);
        if (pool == null) {
            return null;
        }
        return pool.remove(plid);
    }

    public static Map<String, String[]> clear(HttpServletRequest request, long plid, String portletId) {
        Map<String, Map<String, String[]>> plidPool = RenderParametersPool.get(request, plid);
        if (plidPool == null) {
            return null;
        }
        return plidPool.remove(portletId);
    }

    public static Map<String, Map<String, String[]>> get(HttpServletRequest request, long plid) {
        if (plid <= 0L) {
            return null;
        }
        Map<Long, Map<String, Map<String, String[]>>> pool = RenderParametersPool._getRenderParametersPool(request, false);
        if (pool == null) {
            return null;
        }
        return pool.get(plid);
    }

    public static Map<String, String[]> get(HttpServletRequest request, long plid, String portletId) {
        Map<String, Map<String, String[]>> plidPool = RenderParametersPool.get(request, plid);
        if (plidPool == null) {
            return null;
        }
        return plidPool.get(portletId);
    }

    public static Map<String, Map<String, String[]>> getOrCreate(HttpServletRequest request, long plid) {
        if (plid <= 0L) {
            return new ConcurrentHashMap<String, Map<String, String[]>>();
        }
        Map<Long, Map<String, Map<String, String[]>>> pool = RenderParametersPool._getRenderParametersPool(request, true);
        return pool.computeIfAbsent(plid, key -> new ConcurrentHashMap());
    }

    public static Map<String, String[]> getOrCreate(HttpServletRequest request, long plid, String portletId) {
        Map<String, Map<String, String[]>> plidPool = RenderParametersPool.getOrCreate(request, plid);
        return plidPool.computeIfAbsent(portletId, key -> new HashMap());
    }

    public static void put(HttpServletRequest request, long plid, String portletId, Map<String, String[]> params) {
        if (params.isEmpty()) {
            return;
        }
        Map<String, Map<String, String[]>> plidPool = RenderParametersPool.getOrCreate(request, plid);
        plidPool.put(portletId, params);
    }

    private static Map<Long, Map<String, Map<String, String[]>>> _getRenderParametersPool(HttpServletRequest request, boolean createIfAbsent) {
        HttpSession session = request.getSession();
        HttpSession portalSession = PortalSessionContext.get((String)session.getId());
        if (portalSession != null) {
            session = portalSession;
        }
        ConcurrentHashMap renderParametersPool = (ConcurrentHashMap)session.getAttribute("PORTLET_RENDER_PARAMETERS_");
        if (createIfAbsent && renderParametersPool == null) {
            renderParametersPool = new ConcurrentHashMap();
            session.setAttribute("PORTLET_RENDER_PARAMETERS_", renderParametersPool);
        }
        return renderParametersPool;
    }
}

