/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.kernel.util.comparator;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryEntry;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Date;

public class RepositoryModelCreateDateComparator<T>
extends OrderByComparator<T> {
    public static final String ORDER_BY_ASC = "createDate ASC";
    public static final String ORDER_BY_DESC = "createDate DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"createDate"};
    public static final String ORDER_BY_MODEL_ASC = "modelFolder DESC, createDate ASC";
    public static final String ORDER_BY_MODEL_DESC = "modelFolder DESC, createDate DESC";
    private final boolean _ascending;
    private final boolean _orderByModel;

    public RepositoryModelCreateDateComparator() {
        this(false);
    }

    public RepositoryModelCreateDateComparator(boolean ascending) {
        this._ascending = ascending;
        this._orderByModel = false;
    }

    public RepositoryModelCreateDateComparator(boolean ascending, boolean orderByModel) {
        this._ascending = ascending;
        this._orderByModel = orderByModel;
    }

    @Override
    public int compare(T t1, T t2) {
        int value = 0;
        Date createDate1 = this.getCreateDate(t1);
        Date createDate2 = this.getCreateDate(t2);
        value = this._orderByModel ? ((t1 instanceof DLFolder || t1 instanceof Folder) && (t2 instanceof DLFolder || t2 instanceof Folder) ? DateUtil.compareTo(createDate1, createDate2) : (t1 instanceof DLFolder || t1 instanceof Folder ? -1 : (t2 instanceof DLFolder || t2 instanceof Folder ? 1 : DateUtil.compareTo(createDate1, createDate2)))) : DateUtil.compareTo(createDate1, createDate2);
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._orderByModel) {
            if (this._ascending) {
                return ORDER_BY_MODEL_ASC;
            }
            return ORDER_BY_MODEL_DESC;
        }
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }

    protected Date getCreateDate(Object obj) {
        if (obj instanceof DLFileEntry) {
            DLFileEntry dlFileEntry = (DLFileEntry)obj;
            return dlFileEntry.getCreateDate();
        }
        if (obj instanceof DLFileShortcut) {
            DLFileShortcut dlFileShortcut = (DLFileShortcut)obj;
            return dlFileShortcut.getCreateDate();
        }
        if (obj instanceof DLFolder) {
            DLFolder dlFolder = (DLFolder)obj;
            return dlFolder.getCreateDate();
        }
        RepositoryEntry repositoryEntry = (RepositoryEntry)obj;
        return repositoryEntry.getCreateDate();
    }
}

