/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.kernel.lar;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;

@ProviderType
public class StagedModelType {
    public static final String REFERRER_CLASS_NAME_ALL = "referrer-class-name-all";
    public static final String REFERRER_CLASS_NAME_ANY = "referrer-class-name-any";
    public static final int REFERRER_CLASS_NAME_ID_ALL = -1;
    public static final int REFERRER_CLASS_NAME_ID_ANY = -2;
    private String _className;
    private long _classNameId;
    private String _classSimpleName;
    private String _referrerClassName;
    private long _referrerClassNameId;

    public StagedModelType(Class<?> clazz) {
        this.setClassName(clazz.getName());
    }

    public StagedModelType(Class<?> clazz, Class<?> referrerClass) {
        this.setClassName(clazz.getName());
        this.setReferrerClassName(referrerClass.getName());
    }

    public StagedModelType(long classNameId) {
        this.setClassNameId(classNameId);
    }

    public StagedModelType(long classNameId, long referrerClassNameId) {
        this.setClassNameId(classNameId);
        this.setReferrerClassNameId(referrerClassNameId);
    }

    public StagedModelType(String className) {
        this.setClassName(className);
    }

    public StagedModelType(String className, String referrerClassName) {
        this.setClassName(className);
        this.setReferrerClassName(referrerClassName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof StagedModelType)) {
            return false;
        }
        StagedModelType stagedModelType = (StagedModelType)obj;
        return stagedModelType._classNameId == this._classNameId && stagedModelType._referrerClassNameId == this._referrerClassNameId;
    }

    public String getClassName() {
        return this._className;
    }

    public long getClassNameId() {
        return this._classNameId;
    }

    public String getClassSimpleName() {
        return this._classSimpleName;
    }

    public String getReferrerClassName() {
        return this._referrerClassName;
    }

    public long getReferrerClassNameId() {
        return this._referrerClassNameId;
    }

    public int hashCode() {
        int hashCode = HashUtil.hash(0, this._classNameId);
        return HashUtil.hash(hashCode, this._referrerClassNameId);
    }

    public String toString() {
        if (this._referrerClassNameId <= 0L) {
            return this._className;
        }
        return this._className.concat("#").concat(this._referrerClassName);
    }

    protected String getSimpleName(String className) {
        if (Validator.isNull(className)) {
            return "";
        }
        int pos = className.lastIndexOf(".") + 1;
        if (pos <= 0) {
            return className;
        }
        return className.substring(pos);
    }

    protected void setClassName(String className) {
        this._className = className;
        this._classSimpleName = this.getSimpleName(this._className);
        this._classNameId = Validator.isNotNull(className) ? PortalUtil.getClassNameId(className) : 0L;
    }

    protected void setClassNameId(long classNameId) {
        if (classNameId > 0L) {
            this._className = PortalUtil.getClassName(classNameId);
            this._classSimpleName = this.getSimpleName(this._className);
        } else {
            this._className = null;
            this._classSimpleName = null;
        }
        this._classNameId = classNameId;
    }

    protected void setClassSimpleName(String classSimpleName) {
        this._classSimpleName = classSimpleName;
    }

    protected void setReferrerClassName(String referrerClassName) {
        this._referrerClassName = referrerClassName;
        this._referrerClassNameId = Validator.isNull(referrerClassName) ? 0L : (referrerClassName.equals(REFERRER_CLASS_NAME_ALL) ? -1L : (referrerClassName.equals(REFERRER_CLASS_NAME_ANY) ? -2L : PortalUtil.getClassNameId(referrerClassName)));
    }

    protected void setReferrerClassNameId(long referrerClassNameId) {
        this._referrerClassNameId = referrerClassNameId;
        if (referrerClassNameId == 0L) {
            this._referrerClassName = null;
        } else if (referrerClassNameId == -1L) {
            this._referrerClassName = REFERRER_CLASS_NAME_ALL;
        } else if (referrerClassNameId == -2L) {
            this._referrerClassName = REFERRER_CLASS_NAME_ANY;
        } else if (referrerClassNameId > 0L) {
            this._referrerClassName = PortalUtil.getClassName(referrerClassNameId);
        }
    }
}

