/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.jdbc;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.jndi.JNDIUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.dao.orm.UpgradeOptimizedConnectionProvider;
import com.liferay.portal.kernel.upgrade.dao.orm.UpgradeOptimizedConnectionProviderRegistryUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DataAccess {
    private static final Log _log = LogFactoryUtil.getLog(DataAccess.class);
    private static final PACL _pacl = new NoPACL();

    public static void cleanUp(Connection connection) {
        block3: {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sqle) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(sqle.getMessage());
            }
        }
    }

    public static void cleanUp(Connection connection, Statement statement) {
        DataAccess.cleanUp(statement);
        DataAccess.cleanUp(connection);
    }

    public static void cleanUp(Connection connection, Statement statement, ResultSet resultSet) {
        DataAccess.cleanUp(resultSet);
        DataAccess.cleanUp(statement);
        DataAccess.cleanUp(connection);
    }

    public static void cleanUp(ResultSet resultSet) {
        block3: {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sqle) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(sqle.getMessage());
            }
        }
    }

    public static void cleanUp(Statement statement) {
        block3: {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sqle) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(sqle.getMessage());
            }
        }
    }

    public static void cleanUp(Statement statement, ResultSet resultSet) {
        DataAccess.cleanUp(resultSet);
        DataAccess.cleanUp(statement);
    }

    public static void deepCleanUp(ResultSet resultSet) {
        block3: {
            try {
                if (resultSet != null) {
                    Statement statement = resultSet.getStatement();
                    Connection connection = statement.getConnection();
                    DataAccess.cleanUp(connection, statement, resultSet);
                }
            }
            catch (SQLException sqle) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(sqle.getMessage());
            }
        }
    }

    public static Connection getConnection() throws SQLException {
        DataSource dataSource = _pacl.getDataSource();
        return dataSource.getConnection();
    }

    public static Connection getConnection(String location) throws NamingException, SQLException {
        DataSource dataSource = _pacl.getDataSource(location);
        return dataSource.getConnection();
    }

    public static Connection getUpgradeOptimizedConnection() throws SQLException {
        DB db = DBManagerUtil.getDB();
        DBType dbType = db.getDBType();
        UpgradeOptimizedConnectionProvider upgradeOptimizedConnectionProvider = UpgradeOptimizedConnectionProviderRegistryUtil.getUpgradeOptimizedConnectionProvider(dbType);
        if (upgradeOptimizedConnectionProvider != null) {
            return upgradeOptimizedConnectionProvider.getConnection();
        }
        return DataAccess.getConnection();
    }

    private static class NoPACL
    implements PACL {
        private NoPACL() {
        }

        @Override
        public DataSource getDataSource() {
            return InfrastructureUtil.getDataSource();
        }

        @Override
        public DataSource getDataSource(String location) throws NamingException {
            Properties properties = PropsUtil.getProperties("jndi.environment.", true);
            InitialContext context = new InitialContext(properties);
            return (DataSource)JNDIUtil.lookup(context, location);
        }
    }

    public static interface PACL {
        public DataSource getDataSource();

        public DataSource getDataSource(String var1) throws NamingException;
    }
}

