/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.executor;

import com.liferay.portal.kernel.concurrent.RejectedExecutionHandler;
import com.liferay.portal.kernel.concurrent.ThreadPoolHandler;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import java.io.Serializable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class PortalExecutorConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean _allowCoreThreadTimeout;
    private final int _corePoolSize;
    private final long _keepAliveTime;
    private final int _maxPoolSize;
    private final int _maxQueueSize;
    private final String _name;
    private final RejectedExecutionHandler _rejectedExecutionHandler;
    private final ThreadFactory _threadFactory;
    private final ThreadPoolHandler _threadPoolHandler;
    private final TimeUnit _timeUnit;

    public PortalExecutorConfig(String name, int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, boolean allowCoreThreadTimeout, int maxQueueSize, RejectedExecutionHandler rejectedExecutionHandler, ThreadPoolHandler threadPoolHandler, int priority, ClassLoader contextClassLoader) {
        this._name = name;
        this._corePoolSize = corePoolSize;
        this._maxPoolSize = maxPoolSize;
        this._keepAliveTime = keepAliveTime;
        this._timeUnit = timeUnit;
        this._allowCoreThreadTimeout = allowCoreThreadTimeout;
        this._maxQueueSize = maxQueueSize;
        this._rejectedExecutionHandler = rejectedExecutionHandler;
        this._threadPoolHandler = threadPoolHandler;
        this._threadFactory = new NamedThreadFactory(name, priority, contextClassLoader);
    }

    public int getCorePoolSize() {
        return this._corePoolSize;
    }

    public long getKeepAliveTime() {
        return this._keepAliveTime;
    }

    public int getMaxPoolSize() {
        return this._maxPoolSize;
    }

    public int getMaxQueueSize() {
        return this._maxQueueSize;
    }

    public String getName() {
        return this._name;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this._rejectedExecutionHandler;
    }

    public ThreadFactory getThreadFactory() {
        return this._threadFactory;
    }

    public ThreadPoolHandler getThreadPoolHandler() {
        return this._threadPoolHandler;
    }

    public TimeUnit getTimeUnit() {
        return this._timeUnit;
    }

    public boolean isAllowCoreThreadTimeout() {
        return this._allowCoreThreadTimeout;
    }
}

