/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.model;

import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.Validator;
import java.util.Objects;

@Deprecated
public class PortletInstance {
    public static final int PORTLET_INSTANCE_KEY_MAX_LENGTH = PortletIdCodec.PORTLET_INSTANCE_KEY_MAX_LENGTH;
    private final String _instanceId;
    private final String _portletName;
    private final long _userId;

    public static PortletInstance fromPortletInstanceKey(String portletInstanceKey) {
        return new PortletInstance(PortletInstance._getPortletName(portletInstanceKey), PortletInstance._getUserId(portletInstanceKey), PortletInstance._getInstanceId(portletInstanceKey));
    }

    public static PortletInstance fromPortletNameAndUserIdAndInstanceId(String portletName, String userIdAndInstanceId) {
        ObjectValuePair<Long, String> objectValuePair = PortletInstance._decodeUserIdAndInstanceId(userIdAndInstanceId);
        return new PortletInstance(portletName, objectValuePair.getKey(), objectValuePair.getValue());
    }

    public PortletInstance(String portletName) {
        this(portletName, PortletIdCodec.generateInstanceId());
    }

    public PortletInstance(String portletName, long userId) {
        this(portletName, userId, null);
    }

    public PortletInstance(String portletName, long userId, String instanceId) {
        this._validatePortletName(portletName);
        this._portletName = portletName;
        this._userId = userId;
        this._instanceId = instanceId;
    }

    public PortletInstance(String portletName, String instanceId) {
        this(portletName, 0L, instanceId);
    }

    public String getInstanceId() {
        return this._instanceId;
    }

    public String getPortletInstanceKey() {
        return PortletIdCodec.encode(this._portletName, this._userId, this._instanceId);
    }

    public String getPortletName() {
        return this._portletName;
    }

    public long getUserId() {
        return this._userId;
    }

    public String getUserIdAndInstanceId() {
        return PortletIdCodec.encodeUserIdAndInstanceId(this._userId, this._instanceId);
    }

    public boolean hasIdenticalPortletName(PortletInstance portletInstance) {
        return this.hasIdenticalPortletName(portletInstance.getPortletName());
    }

    public boolean hasIdenticalPortletName(String portletName) {
        return Objects.equals(this._portletName, portletName);
    }

    public boolean hasInstanceId() {
        return Validator.isNotNull(this._instanceId);
    }

    public boolean hasUserId() {
        return this._userId > 0L;
    }

    public String toString() {
        return this.getPortletInstanceKey();
    }

    private static ObjectValuePair<Long, String> _decodeUserIdAndInstanceId(String userIdAndInstanceId) {
        return PortletIdCodec.decodeUserIdAndInstanceId(userIdAndInstanceId);
    }

    private static String _getInstanceId(String portletInstanceKey) {
        return PortletIdCodec.decodeInstanceId(portletInstanceKey);
    }

    private static String _getPortletName(String portletInstanceKey) {
        return PortletIdCodec.decodePortletName(portletInstanceKey);
    }

    private static long _getUserId(String portletInstanceKey) {
        return PortletIdCodec.decodeUserId(portletInstanceKey);
    }

    private void _validatePortletName(String portletName) {
        PortletIdCodec.validatePortletName(portletName);
    }
}

