/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

public class RSSUtil {
    public static final String ATOM = "atom";
    public static final String DISPLAY_STYLE_ABSTRACT = "abstract";
    public static final String DISPLAY_STYLE_DEFAULT = RSSUtil._getDisplayStyleDefault();
    public static final String DISPLAY_STYLE_FULL_CONTENT = "full-content";
    public static final String DISPLAY_STYLE_TITLE = "title";
    public static final String[] DISPLAY_STYLES = new String[]{"abstract", "full-content", "title"};
    public static final String ENTRY_TYPE_DEFAULT = "html";
    public static final String FEED_TYPE_DEFAULT = RSSUtil._getFeedTypeDefault();
    public static final String[] FEED_TYPES = RSSUtil._getFeedTypes();
    public static final String FORMAT_DEFAULT = RSSUtil.getFeedTypeFormat(FEED_TYPE_DEFAULT);
    public static final String RSS = "rss";
    public static final double VERSION_DEFAULT = RSSUtil.getFeedTypeVersion(FEED_TYPE_DEFAULT);

    public static String getFeedType(String type, double version) {
        return type + "_" + version;
    }

    public static String getFeedTypeFormat(String feedType) {
        String[] parts;
        if (Validator.isNotNull(feedType) && (parts = StringUtil.split(feedType, "_")).length == 2) {
            return GetterUtil.getString(parts[0], FORMAT_DEFAULT);
        }
        return FORMAT_DEFAULT;
    }

    public static String getFeedTypeName(String feedType) {
        String type = RSSUtil.getFeedTypeFormat(feedType);
        if (type.equals(ATOM)) {
            type = "Atom";
        } else if (type.equals(RSS)) {
            type = "RSS";
        }
        double version = RSSUtil.getFeedTypeVersion(feedType);
        return type + " " + version;
    }

    public static double getFeedTypeVersion(String feedType) {
        String[] parts;
        if (Validator.isNotNull(feedType) && (parts = StringUtil.split(feedType, "_")).length == 2) {
            return GetterUtil.getDouble(parts[1], VERSION_DEFAULT);
        }
        return VERSION_DEFAULT;
    }

    public static String getFormatType(String format) {
        if (format == null) {
            return FORMAT_DEFAULT;
        }
        int x = format.indexOf(ATOM);
        if (x >= 0) {
            return ATOM;
        }
        int y = format.indexOf(RSS);
        if (y >= 0) {
            return RSS;
        }
        return FORMAT_DEFAULT;
    }

    public static double getFormatVersion(String format) {
        if (format == null) {
            return VERSION_DEFAULT;
        }
        int x = format.indexOf("10");
        if (x >= 0) {
            return 1.0;
        }
        int y = format.indexOf("20");
        if (y >= 0) {
            return 2.0;
        }
        return VERSION_DEFAULT;
    }

    private static String _getDisplayStyleDefault() {
        return GetterUtil.getString(PropsUtil.get("rss.feed.display.style.default"), DISPLAY_STYLE_FULL_CONTENT);
    }

    private static String _getFeedTypeDefault() {
        return GetterUtil.getString(PropsUtil.get("rss.feed.type.default"), RSSUtil.getFeedType(ATOM, 1.0));
    }

    private static String[] _getFeedTypes() {
        return GetterUtil.getStringValues(PropsUtil.getArray("rss.feed.types"), new String[]{FEED_TYPE_DEFAULT});
    }
}

