/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.social.kernel.model;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.model.SocialActivityFeedEntry;
import com.liferay.social.kernel.model.SocialActivityInterpreter;
import com.liferay.social.kernel.model.SocialActivitySet;
import com.liferay.social.kernel.service.SocialActivityLocalServiceUtil;
import com.liferay.social.kernel.service.SocialActivitySetLocalServiceUtil;
import com.liferay.social.kernel.service.persistence.SocialActivityUtil;
import com.liferay.trash.kernel.util.TrashUtil;
import java.util.List;
import java.util.ResourceBundle;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;

public abstract class BaseSocialActivityInterpreter
implements SocialActivityInterpreter {
    private static final Log _log = LogFactoryUtil.getLog(BaseSocialActivityInterpreter.class);
    private final SocialActivityFeedEntry _deprecatedMarkerSocialActivityFeedEntry = new SocialActivityFeedEntry("", "");

    @Override
    public String getSelector() {
        return "";
    }

    @Override
    public boolean hasPermission(PermissionChecker permissionChecker, SocialActivity activity, String actionId, ServiceContext serviceContext) throws Exception {
        return this.hasPermissions(permissionChecker, activity, actionId, serviceContext);
    }

    @Override
    public SocialActivityFeedEntry interpret(SocialActivity activity, ServiceContext serviceContext) {
        try {
            return this.doInterpret(activity, serviceContext);
        }
        catch (Exception e) {
            _log.error("Unable to interpret activity", e);
            return null;
        }
    }

    @Override
    public SocialActivityFeedEntry interpret(SocialActivitySet activitySet, ServiceContext serviceContext) {
        try {
            return this.doInterpret(activitySet, serviceContext);
        }
        catch (Exception e) {
            _log.error("Unable to interpret activity set", e);
            return null;
        }
    }

    @Override
    public void updateActivitySet(long activityId) throws PortalException {
        SocialActivity activity = SocialActivityUtil.fetchByPrimaryKey(activityId);
        if (activity == null || activity.getActivitySetId() > 0L) {
            return;
        }
        long activitySetId = this.getActivitySetId(activityId);
        if (activitySetId > 0L) {
            SocialActivitySetLocalServiceUtil.incrementActivityCount(activitySetId, activityId);
        } else {
            SocialActivitySetLocalServiceUtil.addActivitySet(activityId);
        }
    }

    protected String addNoSuchEntryRedirect(String url, String className, long classPK, ServiceContext serviceContext) throws Exception {
        String viewEntryURL = this.getViewEntryURL(className, classPK, serviceContext);
        if (Validator.isNotNull(viewEntryURL)) {
            return viewEntryURL;
        }
        return HttpUtil.setParameter(url, "noSuchEntryRedirect", viewEntryURL);
    }

    protected String buildLink(String link, String text) {
        StringBundler sb = new StringBundler(5);
        sb.append("<a href=\"");
        sb.append(link);
        sb.append("\">");
        sb.append(text);
        sb.append("</a>");
        return sb.toString();
    }

    @Deprecated
    protected String cleanContent(String content) {
        return StringUtil.shorten(HtmlUtil.extractText(content), 200);
    }

    protected SocialActivityFeedEntry doInterpret(SocialActivity activity, ServiceContext serviceContext) throws Exception {
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        SocialActivityFeedEntry socialActivityFeedEntry = this.doInterpret(activity, themeDisplay);
        if (socialActivityFeedEntry != this._deprecatedMarkerSocialActivityFeedEntry) {
            return socialActivityFeedEntry;
        }
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!this.hasPermissions(permissionChecker, activity, "VIEW", serviceContext)) {
            return null;
        }
        String link = this.getLink(activity, serviceContext);
        String title = this.getTitle(activity, serviceContext);
        if (Validator.isNull(title)) {
            return null;
        }
        String body = this.getBody(activity, serviceContext);
        return new SocialActivityFeedEntry(link, title, body);
    }

    @Deprecated
    protected SocialActivityFeedEntry doInterpret(SocialActivity activity, ThemeDisplay themeDisplay) throws Exception {
        return this._deprecatedMarkerSocialActivityFeedEntry;
    }

    protected SocialActivityFeedEntry doInterpret(SocialActivitySet activitySet, ServiceContext serviceContext) throws Exception {
        List<SocialActivity> activities = SocialActivityLocalServiceUtil.getActivitySetActivities(activitySet.getActivitySetId(), 0, 1);
        if (!activities.isEmpty()) {
            SocialActivity activity = activities.get(0);
            return this.doInterpret(activity, serviceContext);
        }
        return null;
    }

    protected long getActivitySetId(long activityId) {
        return 0L;
    }

    protected String getBody(SocialActivity activity, ServiceContext serviceContext) throws Exception {
        return "";
    }

    protected String getEntryTitle(SocialActivity activity, ServiceContext serviceContext) throws Exception {
        return activity.getExtraDataValue("title", serviceContext.getLocale());
    }

    protected String getGroupName(long groupId, ServiceContext serviceContext) {
        try {
            if (groupId <= 0L) {
                return "";
            }
            Group group = GroupLocalServiceUtil.getGroup(groupId);
            String groupName = group.getDescriptiveName();
            if (group.getGroupId() == serviceContext.getScopeGroupId()) {
                return HtmlUtil.escape(groupName);
            }
            String groupDisplayURL = "";
            if (group.hasPublicLayouts()) {
                groupDisplayURL = group.getDisplayURL(serviceContext.getThemeDisplay(), false);
            } else if (group.hasPrivateLayouts()) {
                groupDisplayURL = group.getDisplayURL(serviceContext.getThemeDisplay(), true);
            } else {
                return HtmlUtil.escape(groupName);
            }
            groupName = "<a class=\"group\" href=\"" + groupDisplayURL + "\">" + HtmlUtil.escape(groupName) + "</a>";
            return groupName;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Deprecated
    protected String getGroupName(long groupId, ThemeDisplay themeDisplay) {
        try {
            if (groupId <= 0L) {
                return "";
            }
            Group group = GroupLocalServiceUtil.getGroup(groupId);
            String groupName = group.getDescriptiveName();
            if (group.getGroupId() == themeDisplay.getScopeGroupId()) {
                return HtmlUtil.escape(groupName);
            }
            String groupDisplayURL = "";
            if (group.hasPublicLayouts()) {
                groupDisplayURL = group.getDisplayURL(themeDisplay, false);
            } else if (group.hasPrivateLayouts()) {
                groupDisplayURL = group.getDisplayURL(themeDisplay, true);
            } else {
                return HtmlUtil.escape(groupName);
            }
            groupName = "<a class=\"group\" href=\"" + groupDisplayURL + "\">" + HtmlUtil.escape(groupName) + "</a>";
            return groupName;
        }
        catch (Exception e) {
            return "";
        }
    }

    protected String getJSONValue(String json, String key) {
        return this.getJSONValue(json, key, "");
    }

    protected String getJSONValue(String json, String key, String defaultValue) {
        if (Validator.isNull(json)) {
            return defaultValue;
        }
        try {
            JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject(json);
            String value = extraDataJSONObject.getString(key);
            if (Validator.isNotNull(value)) {
                return value;
            }
        }
        catch (JSONException jsone) {
            _log.error("Unable to create a JSON object from " + json, jsone);
        }
        return defaultValue;
    }

    protected String getLink(SocialActivity activity, ServiceContext serviceContext) throws Exception {
        long classPK;
        String className = activity.getClassName();
        String viewEntryInTrashURL = this.getViewEntryInTrashURL(className, classPK = activity.getClassPK(), serviceContext);
        if (viewEntryInTrashURL != null) {
            return viewEntryInTrashURL;
        }
        String path = this.getPath(activity, serviceContext);
        if (Validator.isNull(path)) {
            return null;
        }
        if (!(path = this.addNoSuchEntryRedirect(path, className, classPK, serviceContext)).startsWith("/")) {
            return path;
        }
        return serviceContext.getPortalURL() + serviceContext.getPathMain() + path;
    }

    protected String getPath(SocialActivity activity, ServiceContext serviceContext) throws Exception {
        return "";
    }

    protected abstract ResourceBundleLoader getResourceBundleLoader();

    protected String getTitle(SocialActivity activity, ServiceContext serviceContext) throws Exception {
        String titlePattern;
        String groupName = "";
        if (activity.getGroupId() != serviceContext.getScopeGroupId()) {
            groupName = this.getGroupName(activity.getGroupId(), serviceContext);
        }
        if (Validator.isNull(titlePattern = this.getTitlePattern(groupName, activity))) {
            return null;
        }
        String link = this.getLink(activity, serviceContext);
        String entryTitle = this.getEntryTitle(activity, serviceContext);
        Object[] titleArguments = this.getTitleArguments(groupName, activity, link, entryTitle, serviceContext);
        ResourceBundleLoader resourceBundleLoader = this.getResourceBundleLoader();
        if (resourceBundleLoader == null) {
            return serviceContext.translate(titlePattern, titleArguments);
        }
        ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(LanguageUtil.getLanguageId(serviceContext.getLocale()));
        return LanguageUtil.format(resourceBundle, titlePattern, titleArguments);
    }

    protected Object[] getTitleArguments(String groupName, SocialActivity activity, String link, String title, ServiceContext serviceContext) throws Exception {
        String userName = this.getUserName(activity.getUserId(), serviceContext);
        return new Object[]{groupName, userName, this.wrapLink(link, title)};
    }

    protected String getTitlePattern(String groupName, SocialActivity activity) throws Exception {
        return "";
    }

    protected String getUserName(long userId, ServiceContext serviceContext) {
        try {
            if (userId <= 0L) {
                return "";
            }
            User user = UserLocalServiceUtil.getUserById(userId);
            if (user.getUserId() == serviceContext.getUserId()) {
                return HtmlUtil.escape(user.getFirstName());
            }
            String userName = user.getFullName();
            Group group = user.getGroup();
            if (group.getGroupId() == serviceContext.getScopeGroupId()) {
                return HtmlUtil.escape(userName);
            }
            String userDisplayURL = user.getDisplayURL(serviceContext.getThemeDisplay());
            userName = "<a class=\"user\" href=\"" + userDisplayURL + "\">" + HtmlUtil.escape(userName) + "</a>";
            return userName;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Deprecated
    protected String getUserName(long userId, ThemeDisplay themeDisplay) {
        try {
            if (userId <= 0L) {
                return "";
            }
            User user = UserLocalServiceUtil.getUserById(userId);
            if (user.getUserId() == themeDisplay.getUserId()) {
                return HtmlUtil.escape(user.getFirstName());
            }
            String userName = user.getFullName();
            Group group = user.getGroup();
            if (group.getGroupId() == themeDisplay.getScopeGroupId()) {
                return HtmlUtil.escape(userName);
            }
            String userDisplayURL = user.getDisplayURL(themeDisplay);
            userName = "<a class=\"user\" href=\"" + userDisplayURL + "\">" + HtmlUtil.escape(userName) + "</a>";
            return userName;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Deprecated
    protected String getValue(String json, String key, String defaultValue) {
        return this.getJSONValue(json, key, defaultValue);
    }

    protected String getViewEntryInTrashURL(String className, long classPK, ServiceContext serviceContext) throws Exception {
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler(className);
        if (trashHandler != null && trashHandler.isInTrash(classPK)) {
            PortletURL portletURL = TrashUtil.getViewContentURL(serviceContext.getRequest(), className, classPK);
            if (portletURL == null) {
                return null;
            }
            return portletURL.toString();
        }
        return null;
    }

    protected String getViewEntryURL(String className, long classPK, ServiceContext serviceContext) throws Exception {
        AssetRendererFactory<?> assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(className);
        if (assetRendererFactory == null) {
            return null;
        }
        LiferayPortletResponse liferayPortletResponse = serviceContext.getLiferayPortletResponse();
        if (liferayPortletResponse == null) {
            return null;
        }
        if (classPK == 0L) {
            PortletURL portletURL = assetRendererFactory.getURLView(liferayPortletResponse, WindowState.MAXIMIZED);
            return portletURL.toString();
        }
        AssetRenderer<?> assetRenderer = assetRendererFactory.getAssetRenderer(classPK);
        if (assetRenderer == null) {
            return null;
        }
        return assetRenderer.getURLView(liferayPortletResponse, WindowState.MAXIMIZED);
    }

    protected boolean hasPermissions(PermissionChecker permissionChecker, SocialActivity activity, String actionId, ServiceContext serviceContext) throws Exception {
        return false;
    }

    protected String wrapLink(String link, String title) {
        title = HtmlUtil.escape(title);
        if (link == null) {
            return title;
        }
        return this.buildLink(link, title);
    }

    protected String wrapLink(String link, String key, ServiceContext serviceContext) {
        ResourceBundleLoader resourceBundleLoader = this.getResourceBundleLoader();
        ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(serviceContext.getLanguageId());
        String title = LanguageUtil.get(resourceBundle, key);
        return this.wrapLink(link, title);
    }
}

