/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmptyCollectionCheck
extends BaseFileCheck {
    private final Pattern _emptyCollectionPattern = Pattern.compile("Collections\\.EMPTY_(LIST|MAP|SET)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        this._checkEmptyCollection(fileName, content);
        return content;
    }

    private void _checkEmptyCollection(String fileName, String content) {
        Matcher matcher = this._emptyCollectionPattern.matcher(content);
        while (matcher.find()) {
            String collectionType = TextFormatter.format(matcher.group(1), 9);
            this.addMessage(fileName, "Use Collections.empty" + collectionType + "()", this.getLineCount(content, matcher.start()));
        }
    }
}

