/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.comparator.ElementComparator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLCustomSQLOrderCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (fileName.contains("/custom-sql/")) {
            Document document = SourceUtil.readXML(content);
            this.checkElementOrder(fileName, document.getRootElement(), "sql", null, new CustomSQLElementComparator("id"));
        }
        return content;
    }

    private class CustomSQLElementComparator
    extends ElementComparator {
        public CustomSQLElementComparator(String nameAttribute) {
            super(nameAttribute);
        }

        @Override
        public int compare(Element sqlElement1, Element sqlElement2) {
            String finderKeyName2;
            String sqlElementName1 = this.getElementName(sqlElement1);
            String sqlElementName2 = this.getElementName(sqlElement2);
            String finderObjectName1 = this._getFinderObjectName(sqlElementName1);
            String finderObjectName2 = this._getFinderObjectName(sqlElementName2);
            if (finderObjectName1 == null || finderObjectName2 == null) {
                return 0;
            }
            int value = finderObjectName1.compareToIgnoreCase(finderObjectName2);
            if (value != 0) {
                return value;
            }
            String finderKeyName1 = this._getFinderKeyName(sqlElementName1);
            int startsWithWeight = StringUtil.startsWithWeight(finderKeyName1, finderKeyName2 = this._getFinderKeyName(sqlElementName2));
            if (startsWithWeight == 0) {
                return finderKeyName1.compareTo(finderKeyName2);
            }
            String startFinder = finderKeyName1.substring(0, startsWithWeight);
            if (!startFinder.contains("By")) {
                NaturalOrderStringComparator comparator = new NaturalOrderStringComparator();
                return comparator.compare(finderKeyName1, finderKeyName2);
            }
            int columnCount1 = StringUtil.count(sqlElementName1, '_');
            int columnCount2 = StringUtil.count(sqlElementName2, '_');
            return columnCount1 - columnCount2;
        }

        private String _getFinderKeyName(String elementName) {
            if (Validator.isNull(elementName)) {
                return null;
            }
            int pos = elementName.lastIndexOf(".");
            if (pos == -1) {
                return null;
            }
            return elementName.substring(pos + 1);
        }

        private String _getFinderObjectName(String elementName) {
            if (Validator.isNull(elementName)) {
                return null;
            }
            int pos = elementName.lastIndexOf(".");
            if (pos == -1) {
                return null;
            }
            return elementName.substring(0, pos);
        }
    }
}

