/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.kernel.controller;

import aQute.bnd.annotation.ProviderType;
import com.liferay.exportimport.kernel.controller.ExportController;
import com.liferay.exportimport.kernel.controller.ExportImportController;
import com.liferay.exportimport.kernel.controller.ImportController;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceRegistrationMap;
import com.liferay.registry.collections.ServiceRegistrationMapImpl;
import com.liferay.registry.util.StringPlus;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@ProviderType
public class ExportImportControllerRegistryUtil {
    private static final ExportImportControllerRegistryUtil _instance = new ExportImportControllerRegistryUtil();
    private final Map<String, ExportController> _exportControllers = new ConcurrentHashMap<String, ExportController>();
    private final Map<String, ExportImportController> _exportImportControllers = new ConcurrentHashMap<String, ExportImportController>();
    private final Map<String, ImportController> _importControllers = new ConcurrentHashMap<String, ImportController>();
    private final ServiceRegistrationMap<ExportImportController> _serviceRegistrations = new ServiceRegistrationMapImpl();
    private final ServiceTracker<ExportImportController, ExportImportController> _serviceTracker;

    public static ExportController getExportController(String className) {
        return _instance._getExportController(className);
    }

    public static List<ExportImportController> getExportImportControllers() {
        return _instance._getExportImportControllers();
    }

    public static ImportController getImportController(String className) {
        return _instance._getImportController(className);
    }

    public static void register(ExportImportController exportImportController) {
        _instance._register(exportImportController);
    }

    public static void unregister(ExportImportController exportImportController) {
        _instance._unregister(exportImportController);
    }

    private ExportImportControllerRegistryUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(ExportImportController.class, (ServiceTrackerCustomizer)new ExportImportControllerServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private ExportController _getExportController(String className) {
        return this._exportControllers.get(className);
    }

    private List<ExportImportController> _getExportImportControllers() {
        Collection<ExportImportController> values = this._exportImportControllers.values();
        return ListUtil.fromCollection(values);
    }

    private ImportController _getImportController(String className) {
        return this._importControllers.get(className);
    }

    private void _register(ExportImportController exportImportController) {
        Registry registry = RegistryUtil.getRegistry();
        ServiceRegistration serviceRegistration = registry.registerService(ExportImportController.class, (Object)exportImportController);
        this._serviceRegistrations.put((Object)exportImportController, (Object)serviceRegistration);
    }

    private void _unregister(ExportImportController exportImportController) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)this._serviceRegistrations.remove((Object)exportImportController);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    private class ExportImportControllerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ExportImportController, ExportImportController> {
        private ExportImportControllerServiceTrackerCustomizer() {
        }

        public ExportImportController addingService(ServiceReference<ExportImportController> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            ExportImportController exportImportController = (ExportImportController)registry.getService(serviceReference);
            List modelClassNames = StringPlus.asList((Object)serviceReference.getProperty("model.class.name"));
            for (String modelClassName : modelClassNames) {
                if (exportImportController instanceof ExportController) {
                    ExportImportControllerRegistryUtil.this._exportControllers.put(modelClassName, (ExportController)exportImportController);
                } else if (exportImportController instanceof ImportController) {
                    ExportImportControllerRegistryUtil.this._importControllers.put(modelClassName, (ImportController)exportImportController);
                }
                ExportImportControllerRegistryUtil.this._exportImportControllers.put(modelClassName, exportImportController);
            }
            return exportImportController;
        }

        public void modifiedService(ServiceReference<ExportImportController> serviceReference, ExportImportController stagedModelDataHandler) {
        }

        public void removedService(ServiceReference<ExportImportController> serviceReference, ExportImportController exportImportController) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            List modelClassNames = StringPlus.asList((Object)serviceReference.getProperty("model.class.name"));
            for (String modelClassName : modelClassNames) {
                if (exportImportController instanceof ExportController) {
                    ExportImportControllerRegistryUtil.this._exportControllers.remove(modelClassName);
                } else if (exportImportController instanceof ImportController) {
                    ExportImportControllerRegistryUtil.this._importControllers.remove(modelClassName);
                }
                ExportImportControllerRegistryUtil.this._exportImportControllers.remove(modelClassName);
            }
        }
    }
}

