/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.module.framework.service;

import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class IdentifiableOSGiServiceUtil {
    private static final Map<String, IdentifiableOSGiService> _identifiableOSGiServices = new ConcurrentHashMap<String, IdentifiableOSGiService>();
    private static final ServiceTracker<IdentifiableOSGiService, IdentifiableOSGiService> _serviceTracker;

    public static IdentifiableOSGiService getIdentifiableOSGiService(String osgiServiceIdentifier) {
        return _identifiableOSGiServices.get(osgiServiceIdentifier);
    }

    private IdentifiableOSGiServiceUtil() {
    }

    static {
        Registry registry = RegistryUtil.getRegistry();
        _serviceTracker = registry.trackServices(IdentifiableOSGiService.class, (ServiceTrackerCustomizer)new IdentifiableOSGiServiceServiceTrackerCustomizer());
        _serviceTracker.open();
    }

    private static class IdentifiableOSGiServiceServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<IdentifiableOSGiService, IdentifiableOSGiService> {
        private IdentifiableOSGiServiceServiceTrackerCustomizer() {
        }

        public IdentifiableOSGiService addingService(ServiceReference<IdentifiableOSGiService> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            IdentifiableOSGiService identifiableOSGiService = (IdentifiableOSGiService)registry.getService(serviceReference);
            _identifiableOSGiServices.put(identifiableOSGiService.getOSGiServiceIdentifier(), identifiableOSGiService);
            return identifiableOSGiService;
        }

        public void modifiedService(ServiceReference<IdentifiableOSGiService> serviceReference, IdentifiableOSGiService identifiableOSGiService) {
            _identifiableOSGiServices.put(identifiableOSGiService.getOSGiServiceIdentifier(), identifiableOSGiService);
        }

        public void removedService(ServiceReference<IdentifiableOSGiService> serviceReference, IdentifiableOSGiService identifiableOSGiService) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            _identifiableOSGiServices.remove(identifiableOSGiService.getOSGiServiceIdentifier());
        }
    }
}

