/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.security.auth.ScreenNameValidator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;

public class DefaultScreenNameValidator
implements ScreenNameValidator {
    public static final String POSTFIX = "postfix";
    private String _specialChars;

    @Override
    public String getAUIValidatorJS() {
        return "function(val) {var pattern = new RegExp('[^A-Za-z0-9" + this.getSpecialChars() + "]');if (val.match(pattern)) {return false;}return true;}";
    }

    @Override
    public String getDescription(Locale locale) {
        return LanguageUtil.format(locale, "the-screen-name-cannot-be-an-email-address-or-a-reserved-word", (Object[])new String[]{POSTFIX, this.getSpecialChars()}, false);
    }

    @Override
    public boolean validate(long companyId, String screenName) {
        return !Validator.isEmailAddress(screenName) && !StringUtil.equalsIgnoreCase(screenName, POSTFIX) && !this.hasInvalidChars(screenName);
    }

    protected String getSpecialChars() {
        if (this._specialChars == null) {
            String specialChars = PropsUtil.get("users.screen.name.special.characters");
            this._specialChars = specialChars.replaceAll("/", "");
        }
        return this._specialChars;
    }

    protected boolean hasInvalidChars(String screenName) {
        return !screenName.matches("[A-Za-z0-9" + this.getSpecialChars() + "]+");
    }
}

