/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSSCommentsCheck
extends BaseFileCheck {
    private final Pattern _commentFormatPattern = Pattern.compile("^-* ?(\\S.*?\\S) ?-*$");
    private final Pattern _commentPattern = Pattern.compile("/\\*[\n ](.*)[\n ]\\*/");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._formatComments(content);
    }

    private String _formatComments(String content) {
        Matcher commentMatcher = this._commentPattern.matcher(content);
        while (commentMatcher.find()) {
            Matcher commentFormatMatcher = this._commentFormatPattern.matcher(commentMatcher.group(1));
            if (!commentFormatMatcher.find()) continue;
            String comment = commentFormatMatcher.group(1);
            String[] words = StringUtil.split(comment, ' ');
            for (int i = 1; i < words.length; ++i) {
                String word;
                String previousWord = words[i - 1];
                if (previousWord.endsWith(".") || previousWord.equals("/") || (word = words[i]).length() <= 1 || !Character.isUpperCase(word.charAt(0)) || !StringUtil.isLowerCase(word.substring(1))) continue;
                comment = StringUtil.replaceFirst(comment, word, StringUtil.toLowerCase(word));
            }
            content = StringUtil.replaceFirst(content, commentMatcher.group(), "/* ---------- " + comment + " ---------- */");
        }
        return content;
    }
}

