/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.JavaVariable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;

public class JavaFinderImplCustomSQLCheck
extends BaseJavaTermCheck {
    private final Pattern _customQueryVariablePattern = Pattern.compile("=\\s+(\\w+)\\.class\\.getName\\(\\)\\s+\\+\\s+\"([\\.\\w]+)\";");
    private Document _portalCustomSQLDocument;
    private final Pattern _stringUtilReplacePattern = Pattern.compile("sql = StringUtil.replace\\(.*?\\);\n", 32);

    @Override
    public void init() throws Exception {
        this._portalCustomSQLDocument = this.getPortalCustomSQLDocument();
    }

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws Exception {
        JavaClass javaClass = (JavaClass)javaTerm;
        String className = javaClass.getName();
        if (!className.endsWith("FinderImpl")) {
            return javaClass.getContent();
        }
        Document customSQLDocument = this.getCustomSQLDocument(fileName, absolutePath, this._portalCustomSQLDocument);
        String finderName = className.substring(0, className.length() - 4);
        List<JavaTerm> childJavaTerms = javaClass.getChildJavaTerms();
        for (JavaTerm childJavaTerm : childJavaTerms) {
            if (childJavaTerm instanceof JavaMethod) {
                this._checkCustomSQL(fileName, childJavaTerm.getContent(), fileContent, customSQLDocument, finderName);
                continue;
            }
            if (!(childJavaTerm instanceof JavaVariable)) continue;
            this._checkCustomSQLVariable(fileName, childJavaTerm.getName(), childJavaTerm.getContent(), fileContent, customSQLDocument);
        }
        return javaClass.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private void _checkCustomSQL(String fileName, String methodContent, String fileContent, Document customSQLDocument, String finderName) throws Exception {
        if (customSQLDocument == null) {
            return;
        }
        Matcher matcher = this._stringUtilReplacePattern.matcher(methodContent);
        block0: while (matcher.find()) {
            String replaceSQLValue;
            List<String> parameterList = JavaSourceUtil.getParameterList(matcher.group());
            if (parameterList.size() != 3 || (replaceSQLValue = this._getReplaceSQLValue(fileContent, parameterList.get(1))) == null) continue;
            Element rootElement = customSQLDocument.getRootElement();
            for (Element sqlElement : rootElement.elements("sql")) {
                String sql;
                String id = sqlElement.attributeValue("id");
                if (!id.contains(finderName) || !(sql = this._transform(sqlElement.getText())).contains(replaceSQLValue)) continue;
                continue block0;
            }
            int pos = fileContent.indexOf(matcher.group());
            this.addMessage(fileName, StringBundler.concat("SQL '", replaceSQLValue, "' does not exist in the custom-sql file"), this.getLineCount(fileContent, pos));
        }
    }

    private void _checkCustomSQLVariable(String fileName, String variableName, String variableContent, String fileContent, Document customSQLDocument) {
        if (variableContent.contains("@Deprecated") || fileContent.contains("\n@Deprecated")) {
            return;
        }
        Matcher matcher = this._customQueryVariablePattern.matcher(variableContent);
        if (!matcher.find()) {
            return;
        }
        if (customSQLDocument != null) {
            Element rootElement = customSQLDocument.getRootElement();
            for (Element sqlElement : rootElement.elements("sql")) {
                String id = sqlElement.attributeValue("id");
                if (!id.endsWith(matcher.group(1) + matcher.group(2))) continue;
                return;
            }
        }
        int pos = fileContent.indexOf(variableContent);
        this.addMessage(fileName, "'" + variableName + "' points to non-existing custom query", this.getLineCount(fileContent, pos));
    }

    private String _getReplaceSQLValue(String content, String parameterValue) {
        Pattern pattern;
        Matcher matcher;
        if (parameterValue.matches("[A-Z_]+") && (matcher = (pattern = Pattern.compile("final String\\s+" + parameterValue + "\\s+=\\s+(.*?);\n", 32)).matcher(content)).find()) {
            parameterValue = matcher.group(1);
        }
        if (!parameterValue.matches("(?s)\".* .*\"")) {
            return null;
        }
        parameterValue = parameterValue.substring(1, parameterValue.length() - 1);
        return parameterValue.replaceAll("\"\\s+\\+\\s+\"", "");
    }

    private String _transform(String sql) {
        String[] lines;
        StringBundler sb = new StringBundler();
        for (String line : lines = StringUtil.splitLines(sql)) {
            if ((line = line.trim()).startsWith(")")) {
                sb.setIndex(sb.index() - 1);
            }
            sb.append(line);
            if (line.endsWith("(")) continue;
            sb.append(" ");
        }
        return sb.toString();
    }
}

