/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PrincipalExceptionCheck
extends BaseFileCheck {
    private final Pattern _principalExceptionPattern = Pattern.compile("SessionErrors\\.contains\\(\n?\t*(renderR|r)equest, PrincipalException\\.class\\.getName\\(\\)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._formatPrincipalException(content);
    }

    private String _formatPrincipalException(String content) {
        Matcher matcher = this._principalExceptionPattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            String replacement = StringUtil.replace(match, "class.getName", "getNestedClasses");
            content = StringUtil.replace(content, match, replacement);
        }
        return content;
    }
}

