/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;

public class ResourceBundleCheck
extends BaseFileCheck {
    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (this.isExcludedPath("run.outside.portal.excludes", absolutePath)) {
            return content;
        }
        int pos = content.indexOf("ResourceBundle.getBundle(");
        if (pos != -1) {
            this.addMessage(fileName, "Use ResourceBundleUtil.getBundle instead of ResourceBundle.getBundle", "resource_bundle.markdown", this.getLineCount(content, pos));
        }
        if ((pos = content.indexOf("resourceBundle.getString(")) != -1) {
            this.addMessage(fileName, "Use ResourceBundleUtil.getString instead of resourceBundle.getString", "resource_bundle.markdown", this.getLineCount(content, pos));
        }
        return content;
    }
}

