/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.util;

import com.liferay.mail.kernel.model.Filter;
import com.liferay.mail.kernel.util.Hook;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.process.LoggingOutputProcessor;
import com.liferay.petra.process.OutputProcessor;
import com.liferay.petra.process.ProcessUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsUtil;
import java.util.List;

public class ShellHook
implements Hook {
    public static final String SHELL_SCRIPT = PropsUtil.get("mail.hook.shell.script");
    private static final Log _log = LogFactoryUtil.getLog(ShellHook.class);

    public void addFilters(long companyId, long userId, List<String> filters) {
    }

    public void addForward(long companyId, long userId, List<Filter> filters, List<String> emailAddresses, boolean leaveCopy) {
        this.execute(new String[]{SHELL_SCRIPT, "addForward", String.valueOf(userId), StringUtil.merge(emailAddresses)});
    }

    public void addUser(long companyId, long userId, String password, String firstName, String middleName, String lastName, String emailAddress) {
        this.execute(new String[]{SHELL_SCRIPT, "addUser", String.valueOf(userId), password, firstName, middleName, lastName, emailAddress});
    }

    public void addVacationMessage(long companyId, long userId, String emailAddress, String vacationMessage) {
        this.execute(new String[]{SHELL_SCRIPT, "addVacationMessage", String.valueOf(userId), emailAddress, vacationMessage});
    }

    public void deleteEmailAddress(long companyId, long userId) {
        this.execute(new String[]{SHELL_SCRIPT, "deleteEmailAddress", String.valueOf(userId)});
    }

    public void deleteUser(long companyId, long userId) {
        this.execute(new String[]{SHELL_SCRIPT, "deleteUser", String.valueOf(userId)});
    }

    public void updateBlocked(long companyId, long userId, List<String> blocked) {
        this.execute(new String[]{SHELL_SCRIPT, "updateBlocked", String.valueOf(userId), StringUtil.merge(blocked)});
    }

    public void updateEmailAddress(long companyId, long userId, String emailAddress) {
        this.execute(new String[]{SHELL_SCRIPT, "updateEmailAddress", String.valueOf(userId), emailAddress});
    }

    public void updatePassword(long companyId, long userId, String password) {
        this.execute(new String[]{SHELL_SCRIPT, "updatePassword", String.valueOf(userId), password});
    }

    protected void execute(String[] cmdLine) {
        for (int i = 0; i < cmdLine.length; ++i) {
            if (cmdLine[i].trim().length() != 0) continue;
            cmdLine[i] = "_";
        }
        try {
            NoticeableFuture future = ProcessUtil.execute((OutputProcessor)new LoggingOutputProcessor((stdErr, line) -> {
                if (stdErr.booleanValue()) {
                    _log.error(line);
                } else if (_log.isInfoEnabled()) {
                    _log.info(line);
                }
            }), (String[])cmdLine);
            future.get();
        }
        catch (Exception e) {
            _log.error((Object)("Unable to execute shell command " + cmdLine[0]), (Throwable)e);
        }
    }
}

