/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.auto;

import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;

public class PluginAutoDeployListenerHelper {
    private static final Log _log = LogFactoryUtil.getLog(PluginAutoDeployListenerHelper.class);
    private static final Pattern _extPluginPattern = Pattern.compile("-(E|e)xt[-0-9.]*\\+?\\.(war|zip)$");
    private static final Pattern _hookPluginPattern = Pattern.compile("-(H|h)ook[-0-9.]*\\+?\\.(war|zip)$");
    private static final Pattern _themePluginPattern = Pattern.compile("-(T|t)heme[-0-9.]*\\+?\\.(war|zip)$");
    private static final Pattern _webPluginPattern = Pattern.compile("-(W|w)eb[-0-9.]*\\+?\\.(war|zip)$");
    private final File _file;

    public PluginAutoDeployListenerHelper(File file) {
        this._file = file;
    }

    public boolean isExtPlugin() {
        Matcher matcher = _extPluginPattern.matcher(this._file.getName());
        return matcher.find();
    }

    public boolean isHookPlugin() throws AutoDeployException {
        Matcher matcher = _hookPluginPattern.matcher(this._file.getName());
        return matcher.find() && this.isMatchingFile("WEB-INF/liferay-hook.xml", false) && !this.isMatchingFile("WEB-INF/liferay-portlet.xml", false);
    }

    public boolean isLayoutTemplatePlugin() throws AutoDeployException {
        return this.isMatchingFile("WEB-INF/liferay-layout-templates.xml") && !this.isThemePlugin();
    }

    public boolean isLiferayPackage() {
        String fileName = this._file.getName();
        return fileName.endsWith(".lpkg");
    }

    public boolean isMatchingFile(String checkXmlFile) throws AutoDeployException {
        return this.isMatchingFile(checkXmlFile, true);
    }

    public boolean isMatchingFile(String checkXmlFile, boolean checkFileExtension) throws AutoDeployException {
        if (checkFileExtension && !this.isWarOrZip()) {
            return false;
        }
        if (this._file.isDirectory()) {
            File xmlFile = new File(this._file, checkXmlFile);
            return xmlFile.exists();
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this._file);
            if (zipFile.getEntry(checkXmlFile) == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(this._file.getPath() + " does not have " + checkXmlFile));
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            throw new AutoDeployException((Throwable)ioe);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isMatchingFileExtension(String ... extensions) {
        String fileName = this._file.getName();
        fileName = StringUtil.toLowerCase((String)fileName);
        for (String extension : extensions) {
            if (!fileName.endsWith(extension)) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(this._file.getPath() + " has a matching extension"));
            }
            return true;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(this._file.getPath() + " does not have a matching extension"));
        }
        return false;
    }

    public boolean isThemePlugin() throws AutoDeployException {
        if (this.isMatchingFile("WEB-INF/liferay-look-and-feel.xml", false)) {
            return true;
        }
        Matcher matcher = _themePluginPattern.matcher(this._file.getName());
        return matcher.find() && this.isMatchingFile("WEB-INF/liferay-plugin-package.properties", false);
    }

    public boolean isWarOrZip() {
        return this.isMatchingFileExtension(".war", ".zip");
    }

    public boolean isWebPlugin() throws AutoDeployException {
        Matcher matcher = _webPluginPattern.matcher(this._file.getName());
        return matcher.find() && this.isMatchingFile("WEB-INF/liferay-plugin-package.properties", false);
    }

    protected boolean isJarFile() {
        return this.isMatchingFileExtension(".jar");
    }
}

