/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.registry;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryConfiguration;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.capabilities.ConfigurationCapability;
import com.liferay.portal.kernel.repository.capabilities.PortalCapabilityLocator;
import com.liferay.portal.kernel.repository.capabilities.RepositoryEventTriggerCapability;
import com.liferay.portal.kernel.repository.event.RepositoryEventAware;
import com.liferay.portal.kernel.repository.event.RepositoryEventListener;
import com.liferay.portal.kernel.repository.event.RepositoryEventTrigger;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.registry.CapabilityRegistry;
import com.liferay.portal.kernel.repository.registry.RepositoryDefiner;
import com.liferay.portal.kernel.repository.registry.RepositoryEventRegistry;
import com.liferay.portal.kernel.repository.registry.RepositoryFactoryRegistry;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.repository.InitializedLocalRepository;
import com.liferay.portal.repository.InitializedRepository;
import com.liferay.portal.repository.capabilities.CapabilityLocalRepository;
import com.liferay.portal.repository.capabilities.CapabilityRepository;
import com.liferay.portal.repository.registry.DefaultCapabilityRegistry;
import com.liferay.portal.repository.registry.DefaultRepositoryEventRegistry;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RepositoryClassDefinition
implements RepositoryFactory,
RepositoryFactoryRegistry {
    private static volatile PortalCapabilityLocator _portalCapabilityLocator = (PortalCapabilityLocator)ServiceProxyFactory.newServiceTrackedInstance(PortalCapabilityLocator.class, RepositoryClassDefinition.class, (String)"_portalCapabilityLocator", (boolean)false);
    private final Map<Long, LocalRepository> _localRepositories = new ConcurrentHashMap<Long, LocalRepository>();
    private final Map<Long, Repository> _repositories = new ConcurrentHashMap<Long, Repository>();
    private final RepositoryDefiner _repositoryDefiner;
    private RepositoryFactory _repositoryFactory;
    private final RepositoryEventTrigger _rootRepositoryEventTrigger;

    public static final RepositoryClassDefinition fromRepositoryDefiner(RepositoryDefiner repositoryDefiner) {
        DefaultRepositoryEventRegistry defaultRepositoryEventRegistry = new DefaultRepositoryEventRegistry(null);
        RepositoryClassDefinition repositoryClassDefinition = new RepositoryClassDefinition(repositoryDefiner, defaultRepositoryEventRegistry);
        repositoryDefiner.registerRepositoryFactory((RepositoryFactoryRegistry)repositoryClassDefinition);
        repositoryDefiner.registerRepositoryEventListeners((RepositoryEventRegistry)defaultRepositoryEventRegistry);
        return repositoryClassDefinition;
    }

    public LocalRepository createLocalRepository(long repositoryId) throws PortalException {
        if (this._localRepositories.containsKey(repositoryId)) {
            return this._localRepositories.get(repositoryId);
        }
        InitializedLocalRepository initializedLocalRepository = new InitializedLocalRepository();
        DefaultCapabilityRegistry defaultCapabilityRegistry = new DefaultCapabilityRegistry(initializedLocalRepository);
        this._repositoryDefiner.registerCapabilities((CapabilityRegistry)defaultCapabilityRegistry);
        DefaultRepositoryEventRegistry defaultRepositoryEventRegistry = new DefaultRepositoryEventRegistry(this._rootRepositoryEventTrigger);
        this.setUpCommonCapabilities(initializedLocalRepository, defaultCapabilityRegistry, defaultRepositoryEventRegistry);
        defaultCapabilityRegistry.registerCapabilityRepositoryEvents(defaultRepositoryEventRegistry);
        LocalRepository localRepository = this._repositoryFactory.createLocalRepository(repositoryId);
        LocalRepository wrappedLocalRepository = defaultCapabilityRegistry.invokeCapabilityWrappers(localRepository);
        CapabilityLocalRepository capabilityLocalRepository = new CapabilityLocalRepository(wrappedLocalRepository, defaultCapabilityRegistry, defaultRepositoryEventRegistry);
        initializedLocalRepository.setDocumentRepository(capabilityLocalRepository);
        this._localRepositories.put(repositoryId, capabilityLocalRepository);
        return capabilityLocalRepository;
    }

    public Repository createRepository(long repositoryId) throws PortalException {
        if (this._repositories.containsKey(repositoryId)) {
            return this._repositories.get(repositoryId);
        }
        InitializedRepository initializedRepository = new InitializedRepository();
        DefaultCapabilityRegistry defaultCapabilityRegistry = new DefaultCapabilityRegistry(initializedRepository);
        this._repositoryDefiner.registerCapabilities((CapabilityRegistry)defaultCapabilityRegistry);
        DefaultRepositoryEventRegistry defaultRepositoryEventRegistry = new DefaultRepositoryEventRegistry(this._rootRepositoryEventTrigger);
        this.setUpCommonCapabilities(initializedRepository, defaultCapabilityRegistry, defaultRepositoryEventRegistry);
        Repository repository = this._repositoryFactory.createRepository(repositoryId);
        defaultCapabilityRegistry.registerCapabilityRepositoryEvents(defaultRepositoryEventRegistry);
        Repository wrappedRepository = defaultCapabilityRegistry.invokeCapabilityWrappers(repository);
        CapabilityRepository capabilityRepository = new CapabilityRepository(wrappedRepository, defaultCapabilityRegistry, defaultRepositoryEventRegistry);
        initializedRepository.setDocumentRepository(capabilityRepository);
        if (!ExportImportThreadLocal.isImportInProcess()) {
            this._repositories.put(repositoryId, capabilityRepository);
        }
        return capabilityRepository;
    }

    public String getClassName() {
        return this._repositoryDefiner.getClassName();
    }

    public RepositoryConfiguration getRepositoryConfiguration() {
        return this._repositoryDefiner.getRepositoryConfiguration();
    }

    public String getRepositoryTypeLabel(Locale locale) {
        return this._repositoryDefiner.getRepositoryTypeLabel(locale);
    }

    public void invalidateCache() {
        this._localRepositories.clear();
        this._repositories.clear();
    }

    public void setRepositoryFactory(RepositoryFactory repositoryFactory) {
        if (this._repositoryFactory != null) {
            throw new IllegalStateException("Repository factory already exists");
        }
        this._repositoryFactory = repositoryFactory;
    }

    protected RepositoryClassDefinition(RepositoryDefiner repositoryDefiner, RepositoryEventTrigger rootRepositoryEventTrigger) {
        this._repositoryDefiner = repositoryDefiner;
        this._rootRepositoryEventTrigger = rootRepositoryEventTrigger;
    }

    protected void invalidateCachedRepository(long repositoryId) {
        this._localRepositories.remove(repositoryId);
        this._repositories.remove(repositoryId);
    }

    protected void setUpCommonCapabilities(DocumentRepository documentRepository, DefaultCapabilityRegistry capabilityRegistry, RepositoryEventTrigger repositoryEventTrigger) {
        if (!capabilityRegistry.isCapabilityProvided(ConfigurationCapability.class)) {
            capabilityRegistry.addExportedCapability(ConfigurationCapability.class, _portalCapabilityLocator.getConfigurationCapability(documentRepository));
        }
        if (!capabilityRegistry.isCapabilityProvided(RepositoryEventTriggerCapability.class)) {
            capabilityRegistry.addExportedCapability(RepositoryEventTriggerCapability.class, _portalCapabilityLocator.getRepositoryEventTriggerCapability(documentRepository, repositoryEventTrigger));
        }
        capabilityRegistry.addSupportedCapability(CacheCapability.class, new CacheCapability());
    }

    private class CacheCapability
    implements Capability,
    RepositoryEventAware {
        private CacheCapability() {
        }

        public void registerRepositoryEventListeners(RepositoryEventRegistry repositoryEventRegistry) {
            repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Delete.class, LocalRepository.class, (RepositoryEventListener)new RepositoryEventListener<RepositoryEventType.Delete, LocalRepository>(){

                public void execute(LocalRepository localRepository) {
                    RepositoryClassDefinition.this.invalidateCachedRepository(localRepository.getRepositoryId());
                }
            });
        }
    }
}

