/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.hibernate;

import com.liferay.portal.spring.hibernate.SpringHibernateThreadLocalUtil;
import java.sql.Connection;
import java.util.Date;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.jdbc.Work;
import org.springframework.orm.hibernate3.HibernateTransactionManager;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;

public class PortletTransactionManager
implements PlatformTransactionManager {
    private final HibernateTransactionManager _portalHibernateTransactionManager;
    private final SessionFactory _portletSessionFactory;

    public PortletTransactionManager(HibernateTransactionManager portalHibernateTransactionManager, SessionFactory portletSessionFactory) {
        this._portalHibernateTransactionManager = portalHibernateTransactionManager;
        this._portletSessionFactory = portletSessionFactory;
    }

    public void commit(TransactionStatus transactionStatus) throws TransactionException {
        if (!(transactionStatus instanceof TransactionStatusWrapper)) {
            this._portalHibernateTransactionManager.commit(transactionStatus);
            return;
        }
        Throwable throwable = null;
        try {
            TransactionStatusWrapper transactionStatusWrapper = (TransactionStatusWrapper)transactionStatus;
            transactionStatus = transactionStatusWrapper._transactionStatus;
            transactionStatusWrapper.reset();
        }
        catch (Throwable t) {
            throwable = t;
            throw t;
        }
        finally {
            if (throwable == null) {
                this._portalHibernateTransactionManager.commit(transactionStatus);
            } else {
                this._portalHibernateTransactionManager.rollback(transactionStatus);
            }
        }
    }

    public SessionFactory getPortletSessionFactory() {
        return this._portletSessionFactory;
    }

    public TransactionStatus getTransaction(TransactionDefinition transactionDefinition) throws TransactionException {
        TransactionStatus portalTransactionStatus = this._portalHibernateTransactionManager.getTransaction(transactionDefinition);
        SessionHolder portalSessionHolder = (SessionHolder)SpringHibernateThreadLocalUtil.getResource(this._portalHibernateTransactionManager.getSessionFactory());
        if (portalSessionHolder == null) {
            return portalTransactionStatus;
        }
        Connection portalConnection = this._getConnection(portalSessionHolder);
        SessionHolder portletSessionHolder = (SessionHolder)SpringHibernateThreadLocalUtil.getResource(this._portletSessionFactory);
        if (portletSessionHolder != null) {
            if (portalConnection == this._getConnection(portletSessionHolder)) {
                return portalTransactionStatus;
            }
            org.hibernate.Session portalSession = portalSessionHolder.getSession();
            portalSession.flush();
        }
        Session portletSession = this._portletSessionFactory.openSession(portalConnection);
        SpringHibernateThreadLocalUtil.setResource(this._portletSessionFactory, this._createSessionHolder((org.hibernate.Session)portletSession, portalSessionHolder));
        return new TransactionStatusWrapper(portalTransactionStatus, this._portletSessionFactory, portletSessionHolder, (org.hibernate.Session)portletSession);
    }

    public void rollback(TransactionStatus transactionStatus) throws TransactionException {
        if (!(transactionStatus instanceof TransactionStatusWrapper)) {
            this._portalHibernateTransactionManager.rollback(transactionStatus);
            return;
        }
        try {
            TransactionStatusWrapper transactionStatusWrapper = (TransactionStatusWrapper)transactionStatus;
            transactionStatus = transactionStatusWrapper._transactionStatus;
            transactionStatusWrapper.reset();
        }
        finally {
            this._portalHibernateTransactionManager.rollback(transactionStatus);
        }
    }

    private SessionHolder _createSessionHolder(org.hibernate.Session session, SessionHolder templateSessionHolder) {
        SessionHolder sessionHolder = new SessionHolder(session);
        sessionHolder.setPreviousFlushMode(templateSessionHolder.getPreviousFlushMode());
        if (templateSessionHolder.isRollbackOnly()) {
            sessionHolder.setRollbackOnly();
        }
        sessionHolder.setSynchronizedWithTransaction(templateSessionHolder.isSynchronizedWithTransaction());
        if (templateSessionHolder.hasTimeout()) {
            Date deadline = templateSessionHolder.getDeadline();
            sessionHolder.setTimeoutInMillis(deadline.getTime() - System.currentTimeMillis());
        }
        sessionHolder.setTransaction(templateSessionHolder.getTransaction());
        if (templateSessionHolder.isVoid()) {
            sessionHolder.unbound();
        }
        return sessionHolder;
    }

    private Connection _getConnection(SessionHolder sessionHolder) {
        org.hibernate.Session session = sessionHolder.getSession();
        final ConnectionReference connectionHolder = new ConnectionReference();
        session.doWork(new Work(){

            public void execute(Connection connection) {
                connectionHolder.setConnection(connection);
            }
        });
        return connectionHolder.getConnection();
    }

    private static class TransactionStatusWrapper
    implements TransactionStatus {
        private final org.hibernate.Session _portletSession;
        private final SessionFactory _portletSessionFactory;
        private final SessionHolder _previousPortletSessionHolder;
        private final TransactionStatus _transactionStatus;

        public Object createSavepoint() throws TransactionException {
            return this._transactionStatus.createSavepoint();
        }

        public void flush() {
            this._transactionStatus.flush();
        }

        public boolean hasSavepoint() {
            return this._transactionStatus.hasSavepoint();
        }

        public boolean isCompleted() {
            return this._transactionStatus.isCompleted();
        }

        public boolean isNewTransaction() {
            return this._transactionStatus.isNewTransaction();
        }

        public boolean isRollbackOnly() {
            return this._transactionStatus.isRollbackOnly();
        }

        public void releaseSavepoint(Object savepoint) throws TransactionException {
            this._transactionStatus.releaseSavepoint(savepoint);
        }

        public void reset() {
            try {
                this._portletSession.flush();
            }
            finally {
                SpringHibernateThreadLocalUtil.setResource(this._portletSessionFactory, this._previousPortletSessionHolder);
            }
        }

        public void rollbackToSavepoint(Object savepoint) throws TransactionException {
            this._transactionStatus.rollbackToSavepoint(savepoint);
        }

        public void setRollbackOnly() {
            this._transactionStatus.setRollbackOnly();
        }

        private TransactionStatusWrapper(TransactionStatus transactionStatus, SessionFactory targetSessionFactory, SessionHolder previousPortletSessionHolder, org.hibernate.Session portletSession) {
            this._transactionStatus = transactionStatus;
            this._portletSessionFactory = targetSessionFactory;
            this._previousPortletSessionHolder = previousPortletSessionHolder;
            this._portletSession = portletSession;
        }
    }

    private static class ConnectionReference {
        private Connection _connection;

        private ConnectionReference() {
        }

        public Connection getConnection() {
            return this._connection;
        }

        public void setConnection(Connection connection) {
            this._connection = connection;
        }
    }
}

