/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.kernel.exception.LayoutPermissionException;
import com.liferay.portal.kernel.exception.PortletActiveException;
import com.liferay.portal.kernel.exception.UserActiveException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferencesIds;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserTracker;
import com.liferay.portal.kernel.model.UserTrackerPath;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.auth.InterruptedPortletRequestWhitelistUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.service.persistence.UserTrackerPathUtil;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.liveusers.LiveUsers;
import com.liferay.portal.struts.ActionAdapter;
import com.liferay.portal.struts.AuthPublicPathRegistry;
import com.liferay.portal.struts.StrutsActionRegistryUtil;
import com.liferay.portal.struts.StrutsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.RenderRequestFactory;
import com.liferay.portlet.RenderRequestImpl;
import com.liferay.portlet.RenderResponseFactory;
import com.liferay.portlet.RenderResponseImpl;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletResponse;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.tiles.TilesRequestProcessor;
import org.apache.struts.util.MessageResources;

public class PortalRequestProcessor
extends TilesRequestProcessor {
    private static final String _PATH_C = "/c";
    private static final String _PATH_COMMON = "/common";
    private static final String _PATH_COMMON_ERROR = "/common/error";
    private static final String _PATH_J_SECURITY_CHECK = "/j_security_check";
    private static final String _PATH_PORTAL = "/portal";
    private static final String _PATH_PORTAL_API_JSONWS = "/portal/api/jsonws";
    private static final String _PATH_PORTAL_ERROR = "/portal/error";
    private static final String _PATH_PORTAL_EXPIRE_SESSION = "/portal/expire_session";
    private static final String _PATH_PORTAL_EXTEND_SESSION = "/portal/extend_session";
    private static final String _PATH_PORTAL_FLASH = "/portal/flash";
    private static final String _PATH_PORTAL_J_LOGIN = "/portal/j_login";
    private static final String _PATH_PORTAL_JSON_SERVICE = "/portal/json_service";
    private static final String _PATH_PORTAL_LAYOUT = "/portal/layout";
    private static final String _PATH_PORTAL_LICENSE = "/portal/license";
    private static final String _PATH_PORTAL_LOGIN = "/portal/login";
    private static final String _PATH_PORTAL_LOGOUT = "/portal/logout";
    private static final String _PATH_PORTAL_PROTECTED = "/portal/protected";
    private static final String _PATH_PORTAL_RENDER_PORTLET = "/portal/render_portlet";
    private static final String _PATH_PORTAL_RESILIENCY = "/portal/resiliency";
    private static final String _PATH_PORTAL_SETUP_WIZARD = "/portal/setup_wizard";
    private static final String _PATH_PORTAL_STATUS = "/portal/status";
    private static final String _PATH_PORTAL_TCK = "/portal/tck";
    private static final String _PATH_PORTAL_TERMS_OF_USE = "/portal/terms_of_use";
    private static final String _PATH_PORTAL_UPDATE_EMAIL_ADDRESS = "/portal/update_email_address";
    private static final String _PATH_PORTAL_UPDATE_LANGUAGE = "/portal/update_language";
    private static final String _PATH_PORTAL_UPDATE_PASSWORD = "/portal/update_password";
    private static final String _PATH_PORTAL_UPDATE_REMINDER_QUERY = "/portal/update_reminder_query";
    private static final String _PATH_PORTAL_UPDATE_TERMS_OF_USE = "/portal/update_terms_of_use";
    private static final String _PATH_PORTAL_VERIFY_EMAIL_ADDRESS = "/portal/verify_email_address";
    private static final Log _log = LogFactoryUtil.getLog(PortalRequestProcessor.class);
    private static final Pattern _strutsPortletIgnoredParamtersPattern = Pattern.compile(PropsValues.STRUTS_PORTLET_IGNORED_PARAMETERS_REGEXP);
    private final Set<String> _lastPaths = new HashSet<String>();
    private final Set<String> _publicPaths;
    private final Set<String> _trackerIgnorePaths;

    public PortalRequestProcessor() {
        this._lastPaths.add(_PATH_PORTAL_LAYOUT);
        this.addPaths(this._lastPaths, "auth.forward.last.paths");
        this._publicPaths = new HashSet<String>();
        this._publicPaths.add(_PATH_C);
        this._publicPaths.add(_PATH_PORTAL_API_JSONWS);
        this._publicPaths.add(_PATH_PORTAL_FLASH);
        this._publicPaths.add(_PATH_PORTAL_J_LOGIN);
        this._publicPaths.add(_PATH_PORTAL_LAYOUT);
        this._publicPaths.add(_PATH_PORTAL_LICENSE);
        this._publicPaths.add(_PATH_PORTAL_LOGIN);
        this._publicPaths.add(_PATH_PORTAL_RENDER_PORTLET);
        this._publicPaths.add(_PATH_PORTAL_RESILIENCY);
        this._publicPaths.add(_PATH_PORTAL_TCK);
        this._publicPaths.add(_PATH_PORTAL_UPDATE_LANGUAGE);
        this._publicPaths.add(_PATH_PORTAL_UPDATE_PASSWORD);
        this._publicPaths.add(_PATH_PORTAL_VERIFY_EMAIL_ADDRESS);
        this._publicPaths.add(PropsValues.AUTH_LOGIN_DISABLED_PATH);
        this._trackerIgnorePaths = new HashSet<String>();
        this.addPaths(this._trackerIgnorePaths, "session.tracker.ignore.paths");
    }

    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String path = super.processPath(request, response);
        ActionMapping actionMapping = (ActionMapping)this.moduleConfig.findActionConfig(path);
        if (actionMapping == null && StrutsActionRegistryUtil.getAction(path) == null) {
            String lastPath = this.getLastPath(request);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Last path " + lastPath));
            }
            response.sendRedirect(lastPath);
            return;
        }
        super.process(request, response);
        try {
            if (this.isPortletPath(path)) {
                this.cleanUp(request);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void addPaths(Set<String> paths, String propsKey) {
        String[] pathsArray;
        for (String path : pathsArray = PropsUtil.getArray(propsKey)) {
            paths.add(path);
        }
    }

    protected void callParentDoForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        super.doForward(uri, request, response);
    }

    protected HttpServletRequest callParentProcessMultipart(HttpServletRequest request) {
        return super.processMultipart(request);
    }

    protected String callParentProcessPath(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return super.processPath(request, response);
    }

    protected boolean callParentProcessRoles(HttpServletRequest request, HttpServletResponse response, ActionMapping actionMapping) throws IOException, ServletException {
        return super.processRoles(request, response, actionMapping);
    }

    protected void cleanUp(HttpServletRequest request) throws Exception {
        RenderRequestImpl renderRequestImpl = (RenderRequestImpl)request.getAttribute("javax.portlet.request");
        if (renderRequestImpl != null) {
            renderRequestImpl.cleanUp();
        }
    }

    protected void defineObjects(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws Exception {
        String portletId = portlet.getPortletId();
        ServletContext servletContext = (ServletContext)request.getAttribute("CTX");
        InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        PortletPreferencesIds portletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds((HttpServletRequest)request, (String)portletId);
        PortletPreferences portletPreferences = PortletPreferencesLocalServiceUtil.getStrictPreferences((PortletPreferencesIds)portletPreferencesIds);
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        PortletContext portletContext = portletConfig.getPortletContext();
        RenderRequestImpl renderRequestImpl = RenderRequestFactory.create(request, portlet, invokerPortlet, portletContext, WindowState.MAXIMIZED, PortletMode.VIEW, portletPreferences);
        RenderResponseImpl renderResponseImpl = RenderResponseFactory.create(renderRequestImpl, response);
        renderRequestImpl.defineObjects(portletConfig, (PortletResponse)renderResponseImpl);
        request.setAttribute("PORTLET_STRUTS_EXECUTE", (Object)Boolean.TRUE);
    }

    protected void doForward(String uri, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        StrutsUtil.forward(uri, this.getServletContext(), request, response);
    }

    protected void doInclude(String uri, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        StrutsUtil.include(uri, this.getServletContext(), request, response);
    }

    protected String getFriendlyTrackerPath(String path, ThemeDisplay themeDisplay, HttpServletRequest request) throws Exception {
        if (!path.equals(_PATH_PORTAL_LAYOUT)) {
            return null;
        }
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"p_l_id");
        if (plid == 0L) {
            return null;
        }
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        String layoutFriendlyURL = PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)themeDisplay);
        String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        if (Validator.isNull((String)portletId)) {
            return layoutFriendlyURL;
        }
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
        if (portlet == null) {
            String strutsPath = path.substring(1, path.lastIndexOf(47));
            portlet = PortletLocalServiceUtil.getPortletByStrutsPath((long)companyId, (String)strutsPath);
        }
        if (portlet == null || !portlet.isActive()) {
            return layoutFriendlyURL.concat("?").concat(request.getQueryString());
        }
        String namespace = PortalUtil.getPortletNamespace((String)portletId);
        FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
        if (friendlyURLMapper == null) {
            return layoutFriendlyURL.concat("?").concat(request.getQueryString());
        }
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (Portlet)portlet, (Layout)layout, (String)"RENDER_PHASE");
        Map parameterMap = request.getParameterMap();
        for (Map.Entry entry : parameterMap.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(namespace)) continue;
            key = key.substring(namespace.length());
            portletURL.setParameter(key, (String[])entry.getValue());
        }
        String portletFriendlyURL = friendlyURLMapper.buildPath(portletURL);
        if (portletFriendlyURL != null) {
            return layoutFriendlyURL.concat(portletFriendlyURL);
        }
        return layoutFriendlyURL.concat("?").concat(request.getQueryString());
    }

    protected String getLastPath(HttpServletRequest request) {
        ActionMapping actionMapping;
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Boolean httpsInitial = (Boolean)session.getAttribute("HTTPS_INITIAL");
        String portalURL = null;
        portalURL = PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS && !PropsValues.SESSION_ENABLE_PHISHING_PROTECTION && httpsInitial != null && httpsInitial == false ? PortalUtil.getPortalURL((HttpServletRequest)request, (boolean)false) : PortalUtil.getPortalURL((HttpServletRequest)request);
        StringBundler sb = new StringBundler(7);
        sb.append(portalURL);
        sb.append(themeDisplay.getPathMain());
        sb.append(_PATH_PORTAL_LAYOUT);
        if (!PropsValues.AUTH_FORWARD_BY_LAST_PATH) {
            if (request.getRemoteUser() != null) {
                sb.append("?");
                sb.append("p_l_id");
                sb.append("=");
                sb.append(0L);
            }
            return sb.toString();
        }
        LastPath lastPath = (LastPath)session.getAttribute("LAST_PATH");
        if (lastPath == null) {
            return sb.toString();
        }
        String parameters = lastPath.getParameters();
        if (lastPath.getContextPath().equals(themeDisplay.getPathMain()) && ((actionMapping = (ActionMapping)this.moduleConfig.findActionConfig(lastPath.getPath())) == null || parameters.isEmpty())) {
            return sb.toString();
        }
        StringBundler lastPathSB = new StringBundler(4);
        lastPathSB.append(portalURL);
        lastPathSB.append(lastPath.getContextPath());
        lastPathSB.append(lastPath.getPath());
        lastPathSB.append(parameters);
        return lastPathSB.toString();
    }

    protected boolean isPortletPath(String path) {
        return path != null && !path.equals(_PATH_C) && !path.startsWith(_PATH_COMMON) && !path.contains(_PATH_J_SECURITY_CHECK) && !path.startsWith(_PATH_PORTAL);
    }

    protected boolean isPublicPath(String path) {
        return path != null && (this._publicPaths.contains(path) || path.startsWith(_PATH_COMMON) || AuthPublicPathRegistry.contains(path));
    }

    protected Action processActionCreate(HttpServletRequest request, HttpServletResponse response, ActionMapping actionMapping) throws IOException {
        ActionAdapter actionAdapter = (ActionAdapter)StrutsActionRegistryUtil.getAction(actionMapping.getPath());
        if (actionAdapter != null) {
            ActionConfig actionConfig = this.moduleConfig.findActionConfig(actionMapping.getPath());
            if (actionConfig != null) {
                Action originalAction = super.processActionCreate(request, response, actionMapping);
                actionAdapter.setOriginalAction(originalAction);
            }
            return actionAdapter;
        }
        return super.processActionCreate(request, response, actionMapping);
    }

    protected ActionMapping processMapping(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        if (path == null) {
            return null;
        }
        Action action = StrutsActionRegistryUtil.getAction(path);
        if (action != null) {
            ActionMapping actionMapping = (ActionMapping)this.moduleConfig.findActionConfig(path);
            if (actionMapping == null) {
                actionMapping = new ActionMapping();
                actionMapping.setModuleConfig(this.moduleConfig);
                actionMapping.setPath(path);
                request.setAttribute("org.apache.struts.action.mapping.instance", (Object)actionMapping);
            }
            return actionMapping;
        }
        ActionMapping actionMapping = super.processMapping(request, response, path);
        if (actionMapping == null) {
            MessageResources messageResources = this.getInternal();
            String msg = messageResources.getMessage("processInvalid");
            _log.error((Object)("User ID " + request.getRemoteUser()));
            _log.error((Object)("Current URL " + PortalUtil.getCurrentURL((HttpServletRequest)request)));
            _log.error((Object)("Referer " + request.getHeader("Referer")));
            _log.error((Object)("Remote address " + request.getRemoteAddr()));
            _log.error((Object)(msg + " " + path));
        }
        return actionMapping;
    }

    protected HttpServletRequest processMultipart(HttpServletRequest request) {
        return request;
    }

    protected String processPath(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ActionMapping actionMapping;
        String path = GetterUtil.getString((String)super.processPath(request, response));
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        UserTracker userTracker = LiveUsers.getUserTracker(themeDisplay.getCompanyId(), session.getId());
        if (!(userTracker == null || path.equals(_PATH_C) || path.contains(_PATH_J_SECURITY_CHECK) || path.contains(_PATH_PORTAL_PROTECTED) || this._trackerIgnorePaths.contains(path))) {
            int pos;
            String fullPath = null;
            try {
                if (PropsValues.SESSION_TRACKER_FRIENDLY_PATHS_ENABLED) {
                    fullPath = this.getFriendlyTrackerPath(path, themeDisplay, request);
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            String fullPathWithoutQueryString = fullPath;
            if (Validator.isNull(fullPath)) {
                String queryString = request.getQueryString();
                fullPathWithoutQueryString = path;
                fullPath = Validator.isNotNull((String)queryString) ? path.concat("?").concat(queryString) : path;
            }
            if ((pos = fullPathWithoutQueryString.indexOf("?")) != -1) {
                fullPathWithoutQueryString = fullPathWithoutQueryString.substring(0, pos);
            }
            if (!this._trackerIgnorePaths.contains(fullPathWithoutQueryString)) {
                UserTrackerPath userTrackerPath = UserTrackerPathUtil.create((long)0L);
                userTrackerPath.setUserTrackerId(userTracker.getUserTrackerId());
                userTrackerPath.setPath(fullPath);
                userTrackerPath.setPathDate(new Date());
                userTracker.addPath(userTrackerPath);
            }
        }
        String remoteUser = request.getRemoteUser();
        User user = null;
        try {
            user = PortalUtil.getUser((HttpServletRequest)request);
        }
        catch (Exception pos) {
            // empty catch block
        }
        if (this._lastPaths.contains(path) && !this._trackerIgnorePaths.contains(path)) {
            boolean saveLastPath = ParamUtil.getBoolean((HttpServletRequest)request, (String)"saveLastPath", (boolean)true);
            if (themeDisplay.isLifecycleResource() || themeDisplay.isStateExclusive() || themeDisplay.isStatePopUp() || !StringUtil.equalsIgnoreCase((String)request.getMethod(), (String)"GET")) {
                saveLastPath = false;
            }
            if (saveLastPath) {
                LastPath lastPath = (LastPath)request.getAttribute("LAST_PATH");
                if (lastPath == null) {
                    lastPath = new LastPath(themeDisplay.getPathMain(), path, HttpUtil.parameterMapToString((Map)request.getParameterMap()));
                }
                session.setAttribute("LAST_PATH", (Object)lastPath);
            }
        }
        if (PropsValues.SETUP_WIZARD_ENABLED) {
            if (!path.equals(_PATH_PORTAL_LICENSE) && !path.equals(_PATH_PORTAL_STATUS)) {
                return _PATH_PORTAL_SETUP_WIZARD;
            }
        } else if (path.equals(_PATH_PORTAL_SETUP_WIZARD)) {
            return _PATH_PORTAL_LAYOUT;
        }
        if (remoteUser != null || user != null) {
            if (path.equals(_PATH_PORTAL_LOGOUT)) {
                return path;
            }
            if (path.equals(_PATH_PORTAL_EXPIRE_SESSION) || path.equals(_PATH_PORTAL_EXTEND_SESSION)) {
                return path;
            }
            if (path.equals(_PATH_PORTAL_UPDATE_LANGUAGE)) {
                return path;
            }
            if (path.equals(_PATH_PORTAL_UPDATE_TERMS_OF_USE)) {
                return path;
            }
        }
        if (remoteUser != null && user == null) {
            return _PATH_PORTAL_LOGOUT;
        }
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        if (user != null) {
            if (!user.isActive()) {
                SessionErrors.add((HttpSession)session, (String)UserActiveException.class.getName());
                return _PATH_PORTAL_ERROR;
            }
            if (!(path.equals(_PATH_PORTAL_JSON_SERVICE) || path.equals(_PATH_PORTAL_RENDER_PORTLET) || ParamUtil.getBoolean((HttpServletRequest)request, (String)"wsrp") || themeDisplay.isImpersonated() || InterruptedPortletRequestWhitelistUtil.isPortletInvocationWhitelisted((long)companyId, (String)portletId, (String)PortalUtil.getStrutsAction((HttpServletRequest)request)))) {
                block48: {
                    if (!user.isTermsOfUseComplete()) {
                        return _PATH_PORTAL_TERMS_OF_USE;
                    }
                    if (!user.isEmailAddressVerificationComplete()) {
                        if (path.equals(_PATH_PORTAL_UPDATE_EMAIL_ADDRESS)) {
                            return _PATH_PORTAL_UPDATE_EMAIL_ADDRESS;
                        }
                        return _PATH_PORTAL_VERIFY_EMAIL_ADDRESS;
                    }
                    if (user.isPasswordReset()) {
                        try {
                            PasswordPolicy passwordPolicy = user.getPasswordPolicy();
                            if (passwordPolicy == null || passwordPolicy.isChangeable()) {
                                return _PATH_PORTAL_UPDATE_PASSWORD;
                            }
                            break block48;
                        }
                        catch (Exception e) {
                            _log.error((Object)e, (Throwable)e);
                            return _PATH_PORTAL_UPDATE_PASSWORD;
                        }
                    }
                    if (path.equals(_PATH_PORTAL_UPDATE_PASSWORD)) {
                        return _PATH_PORTAL_LAYOUT;
                    }
                }
                if (!user.isEmailAddressComplete()) {
                    return _PATH_PORTAL_UPDATE_EMAIL_ADDRESS;
                }
                if (!user.isDefaultUser() && !user.isReminderQueryComplete()) {
                    return _PATH_PORTAL_UPDATE_REMINDER_QUERY;
                }
            }
        } else if (!this.isPublicPath(path)) {
            SessionErrors.add((HttpSession)session, (String)PrincipalException.class.getName());
            return _PATH_PORTAL_LOGIN;
        }
        if ((actionMapping = (ActionMapping)this.moduleConfig.findActionConfig(path)) == null) {
            Action strutsAction = StrutsActionRegistryUtil.getAction(path);
            if (strutsAction == null) {
                return null;
            }
        } else {
            path = actionMapping.getPath();
        }
        if (this.isPortletPath(path)) {
            try {
                Portlet portlet = null;
                if (Validator.isNotNull((String)portletId)) {
                    portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
                }
                if (portlet == null) {
                    String strutsPath = path.substring(1, path.lastIndexOf(47));
                    portlet = PortletLocalServiceUtil.getPortletByStrutsPath((long)companyId, (String)strutsPath);
                }
                if (portlet != null && portlet.isActive()) {
                    this.defineObjects(request, response, portlet);
                }
            }
            catch (Exception e) {
                request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
                path = _PATH_COMMON_ERROR;
            }
        }
        if (SessionErrors.contains((HttpSession)session, (String)LayoutPermissionException.class.getName())) {
            return _PATH_PORTAL_ERROR;
        }
        return path;
    }

    protected void processPopulate(HttpServletRequest request, HttpServletResponse response, ActionForm actionForm, ActionMapping actionMapping) throws ServletException {
        if (actionForm == null) {
            return;
        }
        boolean hasIgnoredParameter = false;
        Map oldParameterMap = request.getParameterMap();
        LinkedHashMap newParameterMap = new LinkedHashMap(oldParameterMap.size());
        for (Map.Entry entry : oldParameterMap.entrySet()) {
            String name = (String)entry.getKey();
            Matcher matcher = _strutsPortletIgnoredParamtersPattern.matcher(name);
            if (matcher.matches()) {
                hasIgnoredParameter = true;
                continue;
            }
            newParameterMap.put(name, entry.getValue());
        }
        if (hasIgnoredParameter) {
            request = new DynamicServletRequest(request, newParameterMap, false);
        }
        super.processPopulate(request, response, actionForm, actionMapping);
    }

    protected boolean processRoles(HttpServletRequest request, HttpServletResponse response, ActionMapping actionMapping) throws IOException, ServletException {
        String path = actionMapping.getPath();
        if (this.isPublicPath(path)) {
            return true;
        }
        boolean authorized = true;
        User user = null;
        try {
            user = PortalUtil.getUser((HttpServletRequest)request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (user != null && this.isPortletPath(path)) {
            try {
                if (path.equals(_PATH_PORTAL_LOGOUT)) {
                    return true;
                }
                Portlet portlet = null;
                String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
                if (Validator.isNotNull((String)portletId)) {
                    portlet = PortletLocalServiceUtil.getPortletById((long)user.getCompanyId(), (String)portletId);
                }
                String strutsPath = path.substring(1, path.lastIndexOf(47));
                if (portlet != null) {
                    if (!strutsPath.equals(portlet.getStrutsPath())) {
                        throw new PrincipalException.MustBePortletStrutsPath(strutsPath, portletId);
                    }
                } else {
                    portlet = PortletLocalServiceUtil.getPortletByStrutsPath((long)user.getCompanyId(), (String)strutsPath);
                }
                if (portlet != null && portlet.isActive() && !portlet.isSystem()) {
                    ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                    Layout layout = themeDisplay.getLayout();
                    PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
                    if (!PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (Portlet)portlet, (String)"VIEW")) {
                        throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{Portlet.class.getName(), portlet.getPortletId(), "VIEW"});
                    }
                } else if (portlet != null && !portlet.isActive()) {
                    SessionErrors.add((HttpServletRequest)request, (String)PortletActiveException.class.getName());
                    authorized = false;
                }
            }
            catch (Exception e) {
                SessionErrors.add((HttpServletRequest)request, (String)PrincipalException.class.getName());
                authorized = false;
            }
        }
        if (!authorized) {
            ActionForward forwardConfig = actionMapping.findForward(_PATH_PORTAL_ERROR);
            this.processForwardConfig(request, response, (ForwardConfig)forwardConfig);
            return false;
        }
        return true;
    }
}

