/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.util;

import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringBundler;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class BaseUpgradeResourceBlock
extends UpgradeProcess {
    private static final String _INSERT_SQL;

    protected void doUpgrade() throws Exception {
        String className = this.getClassName();
        this._upgradeCompanyScopePermissions(className);
        this._upgradeGroupScopePermissions(className);
        this._upgradeGroupTemplateScopePermissions(className);
        this._upgradeIndividualScopePermissions(className);
        this._removeResourceBlocks(className);
        this.alter(this.getTableClass(), new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "resourceBlockId")});
    }

    protected abstract String getClassName();

    protected abstract String getPrimaryKeyName();

    protected abstract Class<?> getTableClass();

    protected abstract boolean hasUserId();

    private void _addResourcePermissionBatch(PreparedStatement ps, long companyId, String name, int scope, long primKeyId, long roleId, long ownerId, long actionIds) throws SQLException {
        ps.setLong(1, 0L);
        ps.setLong(2, this.increment(ResourcePermission.class.getName()));
        ps.setLong(3, companyId);
        ps.setString(4, name);
        ps.setInt(5, scope);
        ps.setString(6, String.valueOf(primKeyId));
        ps.setLong(7, primKeyId);
        ps.setLong(8, roleId);
        ps.setLong(9, ownerId);
        ps.setLong(10, actionIds);
        ps.setBoolean(11, actionIds % 2L == 1L);
        ps.addBatch();
    }

    private void _removeResourceBlocks(String className) throws SQLException {
        try (PreparedStatement ps = this.connection.prepareStatement("delete from ResourceTypePermission where name = ?");){
            ps.setString(1, className);
            ps.executeUpdate();
        }
        var3_3 = null;
        try (PreparedStatement selectPS = this.connection.prepareStatement("select resourceBlockId from ResourceBlock where name = ?");){
            selectPS.setString(1, className);
            try (ResultSet rs = selectPS.executeQuery();
                 PreparedStatement deletePS = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"delete from ResourceBlockPermission where resourceBlockId = ?");){
                while (rs.next()) {
                    long resourceBlockId = rs.getLong(1);
                    deletePS.setLong(1, resourceBlockId);
                    deletePS.addBatch();
                }
                deletePS.executeBatch();
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        ps = this.connection.prepareStatement("delete from ResourceBlock where name = ?");
        var3_3 = null;
        try {
            ps.setString(1, className);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (ps != null) {
                if (var3_3 != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    ps.close();
                }
            }
        }
    }

    private void _upgradeCompanyScopePermissions(String className) throws SQLException {
        StringBundler sb = new StringBundler(8);
        sb.append("select ResourceTypePermission.companyId, ");
        sb.append("ResourceTypePermission.roleId, ");
        sb.append("ResourceTypePermission.actionIds from ");
        sb.append("ResourceTypePermission inner join Role_ on Role_.roleId =");
        sb.append("ResourceTypePermission.roleId where ");
        sb.append("ResourceTypePermission.groupId = 0 and Role_.type_ = ");
        sb.append(1);
        sb.append(" and ResourceTypePermission.name = ?");
        try (PreparedStatement selectPS = this.connection.prepareStatement(SQLTransformer.transform(sb.toString()));){
            selectPS.setString(1, className);
            try (ResultSet rs = selectPS.executeQuery();
                 PreparedStatement insertPS = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)_INSERT_SQL);){
                while (rs.next()) {
                    long companyId = rs.getLong("companyId");
                    long roleId = rs.getLong("roleId");
                    long actionIds = rs.getLong("actionIds");
                    this._addResourcePermissionBatch(insertPS, companyId, className, 1, companyId, roleId, 0L, actionIds);
                }
                insertPS.executeBatch();
            }
        }
    }

    private void _upgradeGroupScopePermissions(String className) throws SQLException {
        try (PreparedStatement selectPS = this.connection.prepareStatement(SQLTransformer.transform("select companyId, groupId, roleId, actionIds from ResourceTypePermission where groupId != 0 and name = ?"));){
            selectPS.setString(1, className);
            try (ResultSet rs = selectPS.executeQuery();
                 PreparedStatement insertPS = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)_INSERT_SQL);){
                while (rs.next()) {
                    long companyId = rs.getLong("companyId");
                    long groupId = rs.getLong("groupId");
                    long roleId = rs.getLong("roleId");
                    long actionIds = rs.getLong("actionIds");
                    this._addResourcePermissionBatch(insertPS, companyId, className, 2, groupId, roleId, 0L, actionIds);
                }
                insertPS.executeBatch();
            }
        }
    }

    private void _upgradeGroupTemplateScopePermissions(String className) throws SQLException {
        StringBundler sb = new StringBundler(8);
        sb.append("select ResourceTypePermission.companyId, ");
        sb.append("ResourceTypePermission.roleId, ");
        sb.append("ResourceTypePermission.actionIds from ");
        sb.append("ResourceTypePermission inner join Role_ on Role_.roleId =");
        sb.append("ResourceTypePermission.roleId where ");
        sb.append("ResourceTypePermission.groupId = 0 and Role_.type_ != ");
        sb.append(1);
        sb.append(" and ResourceTypePermission.name = ?");
        try (PreparedStatement selectPS = this.connection.prepareStatement(SQLTransformer.transform(sb.toString()));){
            selectPS.setString(1, className);
            try (ResultSet rs = selectPS.executeQuery();
                 PreparedStatement insertPS = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)_INSERT_SQL);){
                while (rs.next()) {
                    long companyId = rs.getLong("companyId");
                    long roleId = rs.getLong("roleId");
                    long actionIds = rs.getLong("actionIds");
                    this._addResourcePermissionBatch(insertPS, companyId, className, 3, 0L, roleId, 0L, actionIds);
                }
                insertPS.executeBatch();
            }
        }
    }

    private void _upgradeIndividualScopePermissions(String className) throws Exception {
        StringBundler sb = new StringBundler(16);
        Class<?> tableClass = this.getTableClass();
        Field tableNameField = tableClass.getField("TABLE_NAME");
        String tableName = (String)tableNameField.get(null);
        String primaryKeyName = this.getPrimaryKeyName();
        sb.append("select ResourceBlock.companyId, ");
        sb.append(tableName);
        sb.append(".");
        sb.append(primaryKeyName);
        sb.append(", ResourceBlockPermission.roleId, ");
        if (this.hasUserId()) {
            sb.append(tableName);
            sb.append(".userId, ");
        }
        sb.append("ResourceBlockPermission.resourceBlockPermissionId, ");
        sb.append("ResourceBlockPermission.actionIds from ");
        sb.append(tableName);
        sb.append(" inner join ResourceBlock on ");
        sb.append("(ResourceBlock.resourceBlockId = ");
        sb.append(tableName);
        sb.append(".resourceBlockId) inner join ResourceBlockPermission on ");
        sb.append("(ResourceBlockPermission.resourceBlockId = ResourceBlock");
        sb.append(".resourceBlockId) where ResourceBlock.name = ?");
        try (PreparedStatement selectPS = this.connection.prepareStatement(SQLTransformer.transform(sb.toString()));){
            selectPS.setString(1, className);
            try (ResultSet rs = selectPS.executeQuery();
                 PreparedStatement insertPS = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)_INSERT_SQL);){
                while (rs.next()) {
                    long companyId = rs.getLong("companyId");
                    long primKeyId = rs.getLong(primaryKeyName);
                    long roleId = rs.getLong("roleId");
                    long userId = 0L;
                    if (this.hasUserId()) {
                        userId = rs.getLong("userId");
                    }
                    long actionIds = rs.getLong("actionIds");
                    this._addResourcePermissionBatch(insertPS, companyId, className, 4, primKeyId, roleId, userId, actionIds);
                }
                insertPS.executeBatch();
            }
        }
    }

    static {
        StringBundler sb = new StringBundler(4);
        sb.append("insert into ResourcePermission(mvccVersion, ");
        sb.append("resourcePermissionId, companyId, name, scope, primKey, ");
        sb.append("primKeyId, roleId, ownerId, actionIds, viewActionId) ");
        sb.append("values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        _INSERT_SQL = sb.toString();
    }
}

