/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.util;

import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class ParallelUpgradeSchemaUtil {
    private static volatile PortalExecutorManager _portalExecutorManager = (PortalExecutorManager)ServiceProxyFactory.newServiceTrackedInstance(PortalExecutorManager.class, ParallelUpgradeSchemaUtil.class, (String)"_portalExecutorManager", (boolean)true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String ... sqlFileNames) throws Exception {
        NoticeableExecutorService executorService = _portalExecutorManager.getPortalExecutor(ParallelUpgradeSchemaUtil.class.getName());
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(sqlFileNames.length);
        try {
            for (String sqlFileName : sqlFileNames) {
                futures.add(executorService.submit(new CallableSQLExecutor(sqlFileName)));
            }
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            executorService.shutdown();
        }
    }

    private static class CallableSQLExecutor
    implements Callable<Void> {
        private final String _sqlFileName;

        @Override
        public Void call() throws Exception {
            DB db = DBManagerUtil.getDB();
            try (LoggingTimer loggingTimer = new LoggingTimer(this._sqlFileName);){
                db.runSQLTemplate(this._sqlFileName, false);
            }
            return null;
        }

        private CallableSQLExecutor(String sqlFileName) {
            this._sqlFileName = sqlFileName;
        }
    }
}

