/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.layouts.admin.kernel.model.LayoutTypePortletConstants;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.PortalPreferencesImpl;
import com.liferay.portlet.PortalPreferencesWrapper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

public class UpgradeCustomizablePortlets
extends UpgradeProcess {
    private static final String _PREFIX = "<name>com.liferay.portal.model.CustomizedPages";
    private static final String _SUFFIX = "</name>";

    public static String namespacePlid(long plid) {
        return "com.liferay.portal.model.CustomizedPages".concat(String.valueOf(plid));
    }

    protected void doUpgrade() throws Exception {
        this.upgradeCustomizablePreferences();
    }

    protected PortalPreferencesWrapper getPortalPreferencesInstance(long ownerId, int ownerType, String xml) {
        PortalPreferencesImpl portalPreferencesImpl = (PortalPreferencesImpl)PortletPreferencesFactoryUtil.fromXML((long)ownerId, (int)ownerType, (String)xml);
        return new PortalPreferencesWrapper(portalPreferencesImpl);
    }

    /*
     * Exception decompiling
     */
    protected PortletPreferences getPortletPreferences(long ownerId, int ownerType, long plid, String portletId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void upgradeCustomizablePreferences() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select ownerId, ownerType, preferences from PortalPreferences where preferences like '%com.liferay.portal.model.CustomizedPages%'");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long ownerId = rs.getLong("ownerId");
                int ownerType = rs.getInt("ownerType");
                String preferences = rs.getString("preferences");
                PortalPreferencesWrapper portalPreferencesWrapper = this.getPortalPreferencesInstance(ownerId, ownerType, preferences);
                this.upgradeCustomizablePreferences(portalPreferencesWrapper, ownerId, ownerType, preferences);
                portalPreferencesWrapper.store();
            }
        }
    }

    protected void upgradeCustomizablePreferences(PortalPreferencesWrapper portalPreferencesWrapper, long ownerId, int ownerType, String preferences) throws Exception {
        PortalPreferencesImpl portalPreferencesImpl = portalPreferencesWrapper.getPortalPreferencesImpl();
        int x = preferences.indexOf(_PREFIX);
        int y = -1;
        if (x != -1) {
            y = preferences.indexOf(_SUFFIX, x += _PREFIX.length());
        } else {
            return;
        }
        while (x != -1) {
            String[] parts = StringUtil.split((String)preferences.substring(x, y), (String)"#");
            long plid = GetterUtil.getLong((String)parts[0]);
            String key = GetterUtil.getString((String)parts[1]);
            if (LayoutTypePortletConstants.isLayoutTemplateColumnName((String)key)) {
                String value = portalPreferencesImpl.getValue(UpgradeCustomizablePortlets.namespacePlid(plid), key);
                ArrayList<String> newPortletIds = new ArrayList<String>();
                StringBundler sb = new StringBundler(4);
                sb.append("update PortletPreferences set ownerId = ?, ");
                sb.append("ownerType = ?, plid = ?, portletId = ? where ");
                sb.append("ownerId = ? and ownerType = ? and plid = ? and ");
                sb.append("portletId = ?");
                try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());){
                    for (String customPortletId : StringUtil.split((String)value)) {
                        String newPortletId = null;
                        if (!PortletIdCodec.hasInstanceId((String)customPortletId)) {
                            newPortletIds.add(customPortletId);
                            continue;
                        }
                        String instanceId = PortletIdCodec.decodeInstanceId((String)customPortletId);
                        newPortletId = PortletIdCodec.encode((String)PortletIdCodec.decodePortletName((String)customPortletId), (long)ownerId, (String)instanceId);
                        ps.setLong(1, ownerId);
                        ps.setInt(2, 4);
                        ps.setLong(3, plid);
                        ps.setString(4, newPortletId);
                        ps.setLong(5, 0L);
                        ps.setInt(6, 3);
                        ps.setLong(7, plid);
                        ps.setString(8, newPortletId);
                        newPortletIds.add(newPortletId);
                        ps.addBatch();
                    }
                    ps.executeBatch();
                }
                value = StringUtil.merge(newPortletIds);
                portalPreferencesImpl.setValue(UpgradeCustomizablePortlets.namespacePlid(plid), key, value);
            }
            x = preferences.indexOf(_PREFIX, y);
            y = -1;
            if (x == -1) continue;
            y = preferences.indexOf(_SUFFIX, x += _PREFIX.length());
        }
    }
}

