/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeRelease
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.upgradeSchemaVersion();
    }

    protected String toSchemaVersion(String buildNumber) {
        StringBuilder sb = new StringBuilder(2 * buildNumber.length());
        for (int i = 0; i < buildNumber.length(); ++i) {
            sb.append(buildNumber.charAt(i));
            sb.append('.');
        }
        if (buildNumber.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    protected void upgradeSchemaVersion() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select distinct buildNumber from Release_ where schemaVersion is null");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                String buildNumber = rs.getString("buildNumber");
                String schemaVersion = this.toSchemaVersion(buildNumber);
                this.runSQL(StringBundler.concat((String[])new String[]{"update Release_ set schemaVersion = '", schemaVersion, "' where buildNumber = ", buildNumber, " and schemaVersion is null"}));
            }
        }
    }
}

