/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.permission;

import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFileShortcutConstants;
import com.liferay.document.library.kernel.service.DLFileShortcutLocalServiceUtil;
import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;

public class DLFileShortcutPermission {
    public static void check(PermissionChecker permissionChecker, DLFileShortcut dlFileShortcut, String actionId) throws PortalException {
        if (!DLFileShortcutPermission.contains(permissionChecker, dlFileShortcut, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, DLFileShortcut.class.getName(), dlFileShortcut.getFileShortcutId(), new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, FileShortcut fileShortcut, String actionId) throws PortalException {
        if (!DLFileShortcutPermission.contains(permissionChecker, fileShortcut, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, FileShortcut.class.getName(), fileShortcut.getFileShortcutId(), new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long fileShortcutId, String actionId) throws PortalException {
        if (!DLFileShortcutPermission.contains(permissionChecker, fileShortcutId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, DLFileShortcut.class.getName(), fileShortcutId, new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, DLFileShortcut dlFileShortcut, String actionId) {
        String portletId = PortletProviderUtil.getPortletId((String)FileShortcut.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)dlFileShortcut.getGroupId(), (String)DLFileShortcutConstants.getClassName(), (long)dlFileShortcut.getFileShortcutId(), (String)portletId, (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        if (permissionChecker.hasOwnerPermission(dlFileShortcut.getCompanyId(), DLFileShortcutConstants.getClassName(), dlFileShortcut.getFileShortcutId(), dlFileShortcut.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(dlFileShortcut.getGroupId(), DLFileShortcutConstants.getClassName(), dlFileShortcut.getFileShortcutId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, FileShortcut fileShortcut, String actionId) throws PortalException {
        return fileShortcut.containsPermission(permissionChecker, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long fileShortcutId, String actionId) throws PortalException {
        DLFileShortcut dlFileShortcut = DLFileShortcutLocalServiceUtil.getFileShortcut((long)fileShortcutId);
        return DLFileShortcutPermission.contains(permissionChecker, dlFileShortcut, actionId);
    }
}

