/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.document.library.kernel.util.DLProcessor;
import com.liferay.document.library.kernel.util.DLProcessorRegistry;
import com.liferay.document.library.kernel.util.DLProcessorThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.collections.ServiceReferenceMapper;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import com.liferay.registry.collections.StringServiceRegistrationMap;
import com.liferay.registry.collections.StringServiceRegistrationMapImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Deprecated
@DoPrivileged
public class DLProcessorRegistryImpl
implements DLProcessorRegistry {
    private static final String[] _DL_FILE_ENTRY_PROCESSORS = PropsUtil.getArray((String)"dl.file.entry.processors");
    private static final Log _log = LogFactoryUtil.getLog(DLProcessorRegistryImpl.class);
    private final List<DLProcessor> _dlProcessors = new ArrayList<DLProcessor>();
    private final ServiceTrackerMap<String, DLProcessor> _dlProcessorServiceTrackerMap = ServiceTrackerCollections.openSingleValueMap(DLProcessor.class, null, (ServiceReferenceMapper)new ServiceReferenceMapper<String, DLProcessor>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void map(ServiceReference<DLProcessor> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
            Registry registry = RegistryUtil.getRegistry();
            DLProcessor dlProcessor = (DLProcessor)registry.getService(serviceReference);
            try {
                emitter.emit((Object)dlProcessor.getType());
            }
            finally {
                registry.ungetService(serviceReference);
            }
        }
    });
    private final StringServiceRegistrationMap<DLProcessor> _serviceRegistrations = new StringServiceRegistrationMapImpl();

    public void afterPropertiesSet() throws Exception {
        ClassLoader classLoader = ClassLoaderUtil.getPortalClassLoader();
        for (String dlProcessorClassName : _DL_FILE_ENTRY_PROCESSORS) {
            DLProcessor dlProcessor = (DLProcessor)InstanceFactory.newInstance((ClassLoader)classLoader, (String)dlProcessorClassName);
            dlProcessor.afterPropertiesSet();
            this.register(dlProcessor);
            this._dlProcessors.add(dlProcessor);
        }
    }

    public void cleanUp(FileEntry fileEntry) {
        if (!DLProcessorThreadLocal.isEnabled()) {
            return;
        }
        Set dlProcessorTypes = this._dlProcessorServiceTrackerMap.keySet();
        for (String dlProcessorType : dlProcessorTypes) {
            DLProcessor dlProcessor = (DLProcessor)this._dlProcessorServiceTrackerMap.getService((Object)dlProcessorType);
            if (!dlProcessor.isSupported(fileEntry.getMimeType())) continue;
            dlProcessor.cleanUp(fileEntry);
        }
    }

    public void cleanUp(FileVersion fileVersion) {
        if (!DLProcessorThreadLocal.isEnabled()) {
            return;
        }
        Set dlProcessorTypes = this._dlProcessorServiceTrackerMap.keySet();
        for (String dlProcessorType : dlProcessorTypes) {
            DLProcessor dlProcessor = (DLProcessor)this._dlProcessorServiceTrackerMap.getService((Object)dlProcessorType);
            if (!dlProcessor.isSupported(fileVersion)) continue;
            dlProcessor.cleanUp(fileVersion);
        }
    }

    public void destroy() throws Exception {
        UnsafeConsumer.accept(this._dlProcessors, DLProcessor::destroy, Exception.class);
    }

    public void exportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        if (fileEntry == null || fileEntry.getSize() == 0L) {
            return;
        }
        FileVersion latestFileVersion = this._getLatestFileVersion(fileEntry, true);
        if (latestFileVersion == null) {
            return;
        }
        Set dlProcessorTypes = this._dlProcessorServiceTrackerMap.keySet();
        for (String dlProcessorType : dlProcessorTypes) {
            DLProcessor dlProcessor = (DLProcessor)this._dlProcessorServiceTrackerMap.getService((Object)dlProcessorType);
            if (!dlProcessor.isSupported(latestFileVersion)) continue;
            dlProcessor.exportGeneratedFiles(portletDataContext, fileEntry, fileEntryElement);
        }
    }

    public DLProcessor getDLProcessor(String dlProcessorType) {
        return (DLProcessor)this._dlProcessorServiceTrackerMap.getService((Object)dlProcessorType);
    }

    public void importGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        if (importedFileEntry == null || importedFileEntry.getSize() == 0L) {
            return;
        }
        FileVersion fileVersion = importedFileEntry.getFileVersion();
        if (fileVersion == null) {
            return;
        }
        Set dlProcessorTypes = this._dlProcessorServiceTrackerMap.keySet();
        for (String dlProcessorType : dlProcessorTypes) {
            DLProcessor dlProcessor = (DLProcessor)this._dlProcessorServiceTrackerMap.getService((Object)dlProcessorType);
            if (!dlProcessor.isSupported(fileVersion)) continue;
            dlProcessor.importGeneratedFiles(portletDataContext, fileEntry, importedFileEntry, fileEntryElement);
        }
    }

    public boolean isPreviewableSize(FileVersion fileVersion) {
        long fileEntryPreviewableProcessorMaxSize = PropsValues.DL_FILE_ENTRY_PREVIEWABLE_PROCESSOR_MAX_SIZE;
        try {
            fileEntryPreviewableProcessorMaxSize = PrefsPropsUtil.getLong("dl.file.entry.previewable.processor.max.size");
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (fileEntryPreviewableProcessorMaxSize == 0L) {
            return false;
        }
        return fileEntryPreviewableProcessorMaxSize <= 0L || fileVersion.getSize() <= fileEntryPreviewableProcessorMaxSize;
    }

    public void register(DLProcessor dlProcessor) {
        Registry registry = RegistryUtil.getRegistry();
        ServiceRegistration previousServiceRegistration = (ServiceRegistration)this._serviceRegistrations.remove((Object)dlProcessor.getType());
        if (previousServiceRegistration != null) {
            previousServiceRegistration.unregister();
        }
        ServiceRegistration serviceRegistration = registry.registerService(DLProcessor.class, (Object)dlProcessor);
        this._serviceRegistrations.put((Object)dlProcessor.getType(), (Object)serviceRegistration);
    }

    public void trigger(FileEntry fileEntry, FileVersion fileVersion) {
        this.trigger(fileEntry, fileVersion, false);
    }

    public void trigger(FileEntry fileEntry, FileVersion fileVersion, boolean trusted) {
        if (!DLProcessorThreadLocal.isEnabled()) {
            return;
        }
        if (fileEntry == null || fileEntry.getSize() == 0L) {
            return;
        }
        FileVersion latestFileVersion = this._getLatestFileVersion(fileEntry, trusted);
        if (latestFileVersion == null) {
            return;
        }
        Set dlProcessorTypes = this._dlProcessorServiceTrackerMap.keySet();
        for (String dlProcessorType : dlProcessorTypes) {
            DLProcessor dlProcessor = (DLProcessor)this._dlProcessorServiceTrackerMap.getService((Object)dlProcessorType);
            if (!dlProcessor.isSupported(latestFileVersion)) continue;
            dlProcessor.trigger(fileVersion, latestFileVersion);
        }
    }

    public void unregister(DLProcessor dlProcessor) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)this._serviceRegistrations.remove((Object)dlProcessor.getType());
        serviceRegistration.unregister();
    }

    private FileVersion _getLatestFileVersion(FileEntry fileEntry, boolean trusted) {
        try {
            return fileEntry.getLatestFileVersion(trusted);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return null;
        }
    }
}

