/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.util.EncryptorException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

@Deprecated
public class Encryptor {
    public static final String ENCODING = "UTF-8";
    public static final String IBM_PROVIDER_CLASS = "com.ibm.crypto.provider.IBMJCE";
    public static final String KEY_ALGORITHM = StringUtil.toUpperCase((String)GetterUtil.getString((String)PropsUtil.get((String)"company.encryption.algorithm")));
    public static final int KEY_SIZE = GetterUtil.getInteger((String)PropsUtil.get((String)"company.encryption.key.size"));
    public static final String PROVIDER_CLASS = GetterUtil.getString((String)SystemProperties.get((String)(Encryptor.class.getName() + ".provider.class")), (String)"com.sun.crypto.provider.SunJCE");
    public static final String SUN_PROVIDER_CLASS = "com.sun.crypto.provider.SunJCE";
    private static final Log _log = LogFactoryUtil.getLog(Encryptor.class);
    private static final Map<String, Cipher> _decryptCipherMap = new ConcurrentHashMap<String, Cipher>(1, 1.0f, 1);
    private static final Map<String, Cipher> _encryptCipherMap = new ConcurrentHashMap<String, Cipher>(1, 1.0f, 1);

    public static String decrypt(Key key, String encryptedString) throws EncryptorException {
        byte[] encryptedBytes = Base64.decode((String)encryptedString);
        return Encryptor.decryptUnencodedAsString(key, encryptedBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decryptUnencodedAsBytes(Key key, byte[] encryptedBytes) throws EncryptorException {
        String algorithm = key.getAlgorithm();
        String cacheKey = algorithm.concat("#").concat(key.toString());
        Cipher cipher = _decryptCipherMap.get(cacheKey);
        try {
            if (cipher == null) {
                Security.addProvider(Encryptor.getProvider());
                cipher = Cipher.getInstance(algorithm);
                cipher.init(2, key);
                _decryptCipherMap.put(cacheKey, cipher);
            }
            Cipher cipher2 = cipher;
            synchronized (cipher2) {
                return cipher.doFinal(encryptedBytes);
            }
        }
        catch (Exception e) {
            throw new EncryptorException(e);
        }
    }

    public static String decryptUnencodedAsString(Key key, byte[] encryptedBytes) throws EncryptorException {
        try {
            byte[] decryptedBytes = Encryptor.decryptUnencodedAsBytes(key, encryptedBytes);
            return new String(decryptedBytes, ENCODING);
        }
        catch (Exception e) {
            throw new EncryptorException(e);
        }
    }

    public static Key deserializeKey(String base64String) {
        byte[] bytes = Base64.decode((String)base64String);
        return new SecretKeySpec(bytes, KEY_ALGORITHM);
    }

    public static String digest(String text) {
        return DigesterUtil.digest((String)text);
    }

    public static String digest(String algorithm, String text) {
        return DigesterUtil.digest((String)algorithm, (String[])new String[]{text});
    }

    public static String encrypt(Key key, String plainText) throws EncryptorException {
        if (key == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Skip encrypting based on a null key");
            }
            return plainText;
        }
        byte[] encryptedBytes = Encryptor.encryptUnencoded(key, plainText);
        return Base64.encode((byte[])encryptedBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encryptUnencoded(Key key, byte[] plainBytes) throws EncryptorException {
        String algorithm = key.getAlgorithm();
        String cacheKey = algorithm.concat("#").concat(key.toString());
        Cipher cipher = _encryptCipherMap.get(cacheKey);
        try {
            if (cipher == null) {
                Security.addProvider(Encryptor.getProvider());
                cipher = Cipher.getInstance(algorithm);
                cipher.init(1, key);
                _encryptCipherMap.put(cacheKey, cipher);
            }
            Cipher cipher2 = cipher;
            synchronized (cipher2) {
                return cipher.doFinal(plainBytes);
            }
        }
        catch (Exception e) {
            throw new EncryptorException(e);
        }
    }

    public static byte[] encryptUnencoded(Key key, String plainText) throws EncryptorException {
        try {
            byte[] decryptedBytes = plainText.getBytes(ENCODING);
            return Encryptor.encryptUnencoded(key, decryptedBytes);
        }
        catch (Exception e) {
            throw new EncryptorException(e);
        }
    }

    public static Key generateKey() throws EncryptorException {
        return Encryptor.generateKey(KEY_ALGORITHM);
    }

    public static Key generateKey(String algorithm) throws EncryptorException {
        try {
            Security.addProvider(Encryptor.getProvider());
            KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm);
            keyGenerator.init(KEY_SIZE, new SecureRandom());
            SecretKey key = keyGenerator.generateKey();
            return key;
        }
        catch (Exception e) {
            throw new EncryptorException(e);
        }
    }

    public static Provider getProvider() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> providerClass = null;
        try {
            providerClass = Class.forName(PROVIDER_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            if (ServerDetector.isWebSphere() && PROVIDER_CLASS.equals(SUN_PROVIDER_CLASS)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((String[])new String[]{"WebSphere does not have ", SUN_PROVIDER_CLASS, ", using ", IBM_PROVIDER_CLASS, " instead"}));
                }
                providerClass = Class.forName(IBM_PROVIDER_CLASS);
            }
            if (System.getProperty("java.vm.vendor").equals("IBM Corporation")) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((String[])new String[]{"IBM JVM does not have ", SUN_PROVIDER_CLASS, ", using ", IBM_PROVIDER_CLASS, " instead"}));
                }
                providerClass = Class.forName(IBM_PROVIDER_CLASS);
            }
            throw cnfe;
        }
        return (Provider)providerClass.newInstance();
    }

    public static String serializeKey(Key key) {
        return Base64.encode((byte[])key.getEncoded());
    }
}

