/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;

public class JSONIndentationCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        int expectedTabCount = 0;
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            int lineCount = 0;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                this._checkIndentation(line, fileName, expectedTabCount, ++lineCount);
                sb.append(line);
                sb.append("\n");
                expectedTabCount = this.getLevel(line, new String[]{"[", "{"}, new String[]{"]", "}"}, expectedTabCount);
            }
        }
        return content;
    }

    private void _checkIndentation(String line, String fileName, int expectedTabCount, int lineCount) {
        if (Validator.isNull(line)) {
            return;
        }
        int leadingTabCount = this.getLeadingTabCount(line);
        if (line.matches("\t*[\\}\\]].*")) {
            --expectedTabCount;
        }
        if (leadingTabCount == expectedTabCount) {
            return;
        }
        StringBundler sb = new StringBundler(5);
        sb.append("Line starts with '");
        sb.append(leadingTabCount);
        sb.append("' tabs, but '");
        sb.append(expectedTabCount);
        sb.append("' tabs are expected");
        this.addMessage(fileName, sb.toString(), lineCount);
    }
}

