/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.bean;

import com.liferay.portal.kernel.bean.BeanProperties;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import jodd.bean.BeanCopy;
import jodd.bean.BeanUtil;
import jodd.typeconverter.Convert;

@DoPrivileged
public class BeanPropertiesImpl
implements BeanProperties {
    private static final Log _log = LogFactoryUtil.getLog(BeanPropertiesImpl.class);

    public void copyProperties(Object source, Object target) {
        try {
            BeanCopy beanCopy = BeanCopy.beans((Object)source, (Object)target);
            beanCopy.copy();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void copyProperties(Object source, Object target, Class<?> editable) {
        try {
            BeanCopy beanCopy = BeanCopy.beans((Object)source, (Object)target);
            beanCopy.includeAs(editable);
            beanCopy.copy();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void copyProperties(Object source, Object target, String[] ignoreProperties) {
        try {
            BeanCopy beanCopy = BeanCopy.beans((Object)source, (Object)target);
            beanCopy.exclude(ignoreProperties);
            beanCopy.copy();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deepCopyProperties(Object source) throws Exception {
        ObjectInputStream objectInputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream((OutputStream)unsyncByteArrayOutputStream);
            objectOutputStream.writeObject(source);
            objectOutputStream.flush();
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(unsyncByteArrayOutputStream.toByteArray());
            objectInputStream = new ObjectInputStream((InputStream)unsyncByteArrayInputStream);
            Object object = objectInputStream.readObject();
            return (T)object;
        }
        finally {
            objectInputStream.close();
            objectOutputStream.close();
        }
    }

    public boolean getBoolean(Object bean, String param) {
        return this.getBoolean(bean, param, false);
    }

    public boolean getBoolean(Object bean, String param, boolean defaultValue) {
        boolean beanValue = defaultValue;
        if (bean != null) {
            try {
                Object value = BeanUtil.getProperty((Object)bean, (String)param);
                beanValue = Convert.toBooleanValue((Object)value, (boolean)defaultValue);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return beanValue;
    }

    public boolean getBooleanSilent(Object bean, String param) {
        return this.getBooleanSilent(bean, param, false);
    }

    public boolean getBooleanSilent(Object bean, String param, boolean defaultValue) {
        boolean beanValue = defaultValue;
        if (bean != null) {
            try {
                Object value = BeanUtil.getProperty((Object)bean, (String)param);
                beanValue = Convert.toBooleanValue((Object)value, (boolean)defaultValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return beanValue;
    }

    public byte getByte(Object bean, String param) {
        return this.getByte(bean, param, (byte)0);
    }

    public byte getByte(Object bean, String param, byte defaultValue) {
        byte beanValue = defaultValue;
        if (bean != null) {
            try {
                Object value = BeanUtil.getProperty((Object)bean, (String)param);
                beanValue = Convert.toByteValue((Object)value, (byte)defaultValue);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return beanValue;
    }

    public byte getByteSilent(Object bean, String param) {
        return this.getByteSilent(bean, param, (byte)0);
    }

    public byte getByteSilent(Object bean, String param, byte defaultValue) {
        byte beanValue = defaultValue;
        if (bean != null) {
            try {
                Object value = BeanUtil.getProperty((Object)bean, (String)param);
                beanValue = Convert.toByteValue((Object)value, (byte)defaultValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return beanValue;
    }

    public double getDouble(Object bean, String param) {
        return this.getDouble(bean, param, 0.0);
    }

    public double getDouble(Object bean, String param, double defaultValue) {
        double beanValue = defaultValue;
        if (bean != null) {
            try {
                Object value = BeanUtil.getProperty((Object)bean, (String)param);
                beanValue = Convert.toDoubleValue((Object)value, (double)defaultValue);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return beanValue;
    }

    public double getDoubleSilent(Object bean, String param) {
        return this.getDoubleSilent(bean, param, 0.0);
    }

    public double getDoubleSilent(Object bean, String param, double defaultValue) {
        double beanValue = defaultValue;
        if (bean != null) {
            try {
                Object value = BeanUtil.getProperty((Object)bean, (String)param);
                beanValue = Convert.toDoubleValue((Object)value, (double)defaultValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return beanValue;
    }

    public float getFloat(Object bean, String param) {
        return this.getFloat(bean, param, 0.0f);
    }

    public float getFloat(Object bean, String param, float defaultValue) {
        float beanValue = defaultValue;
        if (bean != null) {
            try {
                Object value = BeanUtil.getProperty((Object)bean, (String)param);
                beanValue = Convert.toFloatValue((Object)value, (float)defaultValue);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return beanValue;
    }

    public float getFloatSilent(Object bean, String param) {
        return this.getFloatSilent(bean, param, 0.0f);
    }

    public float getFloatSilent(Object bean, String param, float defaultValue) {
        float beanValue = defaultValue;
        if (bean != null) {
            try {
                Object value = BeanUtil.getProperty((Object)bean, (String)param);
                beanValue = Convert.toFloatValue((Object)value, (float)defaultValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return beanValue;
    }

    public int getInteger(Object bean, String param) {
        return this.getInteger(bean, param, 0);
    }

    public int getInteger(Object bean, String param, int defaultValue) {
        int beanValue = defaultValue;
        if (bean != null) {
            try {
                Object value = BeanUtil.getProperty((Object)bean, (String)param);
                beanValue = Convert.toIntValue((Object)value, (int)defaultValue);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return beanValue;
    }

    public int getIntegerSilent(Object bean, String param) {
        return this.getIntegerSilent(bean, param, 0);
    }

    public int getIntegerSilent(Object bean, String param, int defaultValue) {
        int beanValue = defaultValue;
        if (bean != null) {
            try {
                Object value = BeanUtil.getProperty((Object)bean, (String)param);
                beanValue = Convert.toIntValue((Object)value, (int)defaultValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return beanValue;
    }

    public long getLong(Object bean, String param) {
        return this.getLong(bean, param, 0L);
    }

    public long getLong(Object bean, String param, long defaultValue) {
        long beanValue = defaultValue;
        if (bean != null) {
            try {
                Object value = BeanUtil.getProperty((Object)bean, (String)param);
                beanValue = Convert.toLongValue((Object)value, (long)defaultValue);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return beanValue;
    }

    public long getLongSilent(Object bean, String param) {
        return this.getLongSilent(bean, param, 0L);
    }

    public long getLongSilent(Object bean, String param, long defaultValue) {
        long beanValue = defaultValue;
        if (bean != null) {
            try {
                Object value = BeanUtil.getProperty((Object)bean, (String)param);
                beanValue = Convert.toLongValue((Object)value, (long)defaultValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return beanValue;
    }

    public Object getObject(Object bean, String param) {
        return this.getObject(bean, param, null);
    }

    public Object getObject(Object bean, String param, Object defaultValue) {
        Object beanValue = null;
        if (bean != null) {
            try {
                beanValue = BeanUtil.getProperty((Object)bean, (String)param);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        if (beanValue == null) {
            return defaultValue;
        }
        return beanValue;
    }

    public Object getObjectSilent(Object bean, String param) {
        return this.getObjectSilent(bean, param, null);
    }

    public Object getObjectSilent(Object bean, String param, Object defaultValue) {
        Object beanValue = null;
        if (bean != null) {
            try {
                beanValue = BeanUtil.getProperty((Object)bean, (String)param);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (beanValue == null) {
            return defaultValue;
        }
        return beanValue;
    }

    public Class<?> getObjectType(Object bean, String param) {
        return this.getObjectType(bean, param, null);
    }

    public Class<?> getObjectType(Object bean, String param, Class<?> defaultValue) {
        Class beanType = null;
        if (bean != null) {
            try {
                beanType = BeanUtil.getPropertyType((Object)bean, (String)param);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        if (beanType == null) {
            return defaultValue;
        }
        return beanType;
    }

    public Class<?> getObjectTypeSilent(Object bean, String param) {
        return this.getObjectTypeSilent(bean, param, null);
    }

    public Class<?> getObjectTypeSilent(Object bean, String param, Class<?> defaultValue) {
        Class beanType = null;
        if (bean != null) {
            try {
                beanType = BeanUtil.getPropertyType((Object)bean, (String)param);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (beanType == null) {
            return defaultValue;
        }
        return beanType;
    }

    public short getShort(Object bean, String param) {
        return this.getShort(bean, param, (short)0);
    }

    public short getShort(Object bean, String param, short defaultValue) {
        short beanValue = defaultValue;
        if (bean != null) {
            try {
                Object value = BeanUtil.getProperty((Object)bean, (String)param);
                beanValue = Convert.toShortValue((Object)value, (short)defaultValue);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return beanValue;
    }

    public short getShortSilent(Object bean, String param) {
        return this.getShortSilent(bean, param, (short)0);
    }

    public short getShortSilent(Object bean, String param, short defaultValue) {
        short beanValue = defaultValue;
        if (bean != null) {
            try {
                Object value = BeanUtil.getProperty((Object)bean, (String)param);
                beanValue = Convert.toShortValue((Object)value, (short)defaultValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return beanValue;
    }

    public String getString(Object bean, String param) {
        return this.getString(bean, param, "");
    }

    public String getString(Object bean, String param, String defaultValue) {
        String beanValue = defaultValue;
        if (bean != null) {
            try {
                Object value = BeanUtil.getProperty((Object)bean, (String)param);
                beanValue = Convert.toString((Object)value, (String)defaultValue);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return beanValue;
    }

    public String getStringSilent(Object bean, String param) {
        return this.getStringSilent(bean, param, "");
    }

    public String getStringSilent(Object bean, String param, String defaultValue) {
        String beanValue = defaultValue;
        if (bean != null) {
            try {
                Object value = BeanUtil.getProperty((Object)bean, (String)param);
                beanValue = Convert.toString((Object)value, (String)defaultValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return beanValue;
    }

    public void setProperties(Object bean, HttpServletRequest request) {
        this.setProperties(bean, request, new String[0]);
    }

    public void setProperties(Object bean, HttpServletRequest request, String[] ignoreProperties) {
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            Date date;
            Class propertyTypeClass;
            String dateParam;
            String name = (String)enu.nextElement();
            if (ArrayUtil.contains((Object[])ignoreProperties, (Object)name)) continue;
            String value = request.getParameter(name);
            if (Validator.isNull((String)value) && this.getObjectSilent(bean, name) instanceof Number) {
                value = String.valueOf(0);
            }
            BeanUtil.setPropertyForcedSilent((Object)bean, (String)name, (Object)value);
            if (!name.endsWith("Month") || request.getParameter(dateParam = name.substring(0, name.lastIndexOf("Month"))) != null || (propertyTypeClass = BeanUtil.getPropertyType((Object)bean, (String)dateParam)) == null || !propertyTypeClass.equals(Date.class) || (date = this.getDate(dateParam, request)) == null) continue;
            BeanUtil.setPropertyForcedSilent((Object)bean, (String)dateParam, (Object)date);
        }
    }

    public void setProperty(Object bean, String param, Object value) {
        try {
            BeanUtil.setProperty((Object)bean, (String)param, (Object)value);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void setPropertySilent(Object bean, String param, Object value) {
        BeanUtil.setPropertyForcedSilent((Object)bean, (String)param, (Object)value);
    }

    protected Date getDate(String param, HttpServletRequest request) {
        int month = ParamUtil.getInteger((HttpServletRequest)request, (String)(param + "Month"));
        int day = ParamUtil.getInteger((HttpServletRequest)request, (String)(param + "Day"));
        int year = ParamUtil.getInteger((HttpServletRequest)request, (String)(param + "Year"));
        int hour = ParamUtil.getInteger((HttpServletRequest)request, (String)(param + "Hour"), (int)-1);
        int minute = ParamUtil.getInteger((HttpServletRequest)request, (String)(param + "Minute"));
        int amPm = ParamUtil.getInteger((HttpServletRequest)request, (String)(param + "AmPm"));
        if (amPm == 1) {
            hour += 12;
        }
        if (hour == -1) {
            return PortalUtil.getDate((int)month, (int)day, (int)year);
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        try {
            return PortalUtil.getDate((int)month, (int)day, (int)year, (int)hour, (int)minute, (TimeZone)user.getTimeZone(), null);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return null;
        }
    }
}

