/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.portal.dao.db.MySQLDB;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.db.Index;
import com.liferay.portal.kernel.dao.db.IndexMetadata;
import com.liferay.portal.kernel.dao.db.IndexMetadataFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.util.SimpleCounter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingException;

public abstract class BaseDB
implements DB {
    protected static final String ALTER_COLUMN_NAME = "alter_column_name ";
    protected static final String ALTER_COLUMN_TYPE = "alter_column_type ";
    protected static final String ALTER_TABLE_NAME = "alter_table_name ";
    protected static final String CREATE_TABLE = "create table ";
    protected static final String DROP_INDEX = "drop index";
    protected static final String DROP_PRIMARY_KEY = "drop primary key";
    protected static final String[] RENAME_TABLE_TEMPLATE = new String[]{"@old-table@", "@new-table@"};
    protected static final String[] REWORD_TEMPLATE = new String[]{"@table@", "@old-column@", "@new-column@", "@type@", "@nullable@"};
    protected static final String[] TEMPLATE = new String[]{"##", "TRUE", "FALSE", "'01/01/1970'", "CURRENT_TIMESTAMP", " BLOB", " SBLOB", " BOOLEAN", " DATE", " DOUBLE", " INTEGER", " LONG", " STRING", " TEXT", " VARCHAR", " IDENTITY", "COMMIT_TRANSACTION"};
    private static final boolean _SUPPORTS_ALTER_COLUMN_NAME = true;
    private static final boolean _SUPPORTS_ALTER_COLUMN_TYPE = true;
    private static final boolean _SUPPORTS_INLINE_DISTINCT = true;
    private static final boolean _SUPPORTS_QUERYING_AFTER_EXCEPTION = true;
    private static final boolean _SUPPORTS_SCROLLABLE_RESULTS = true;
    private static final boolean _SUPPORTS_UPDATE_WITH_INNER_JOIN = true;
    private static final Log _log = LogFactoryUtil.getLog(BaseDB.class);
    private static final Pattern _columnLengthPattern = Pattern.compile("\\[\\$COLUMN_LENGTH:(\\d+)\\$\\]");
    private static final Pattern _templatePattern;
    private static final Pattern _timestampPattern;
    private final DBType _dbType;
    private final int _majorVersion;
    private final int _minorVersion;
    private boolean _supportsStringCaseSensitiveQuery = true;
    private final Map<String, String> _templateMap = new HashMap<String, String>();

    public void addIndexes(Connection con, String indexesSQL, Set<String> validIndexNames) throws IOException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Adding indexes");
        }
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(indexesSQL));){
            String sql = null;
            while ((sql = unsyncBufferedReader.readLine()) != null) {
                int y;
                int x;
                String indexName;
                if (Validator.isNull((String)sql) || validIndexNames.contains(indexName = sql.substring((x = sql.lastIndexOf(" ", (y = sql.indexOf(" on ")) - 1)) + 1, y))) continue;
                if (_log.isInfoEnabled()) {
                    _log.info((Object)sql);
                }
                try {
                    this.runSQL(con, sql);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)(e.getMessage() + ": " + sql));
                }
            }
        }
    }

    public void buildCreateFile(String sqlDir, String databaseName) throws IOException {
        this.buildCreateFile(sqlDir, databaseName, 0);
        this.buildCreateFile(sqlDir, databaseName, 1);
    }

    public void buildCreateFile(String sqlDir, String databaseName, int population) throws IOException {
        String suffix = this.getSuffix(population);
        File file = new File(StringBundler.concat((String[])new String[]{sqlDir, "/create", suffix, "/create", suffix, "-", this.getServerName(), ".sql"}));
        String content = this.buildCreateFileContent(sqlDir, databaseName, population);
        if (content != null) {
            FileUtil.write((File)file, (String)content);
        }
    }

    public abstract String buildSQL(String var1) throws IOException;

    public void buildSQLFile(String sqlDir, String fileName) throws IOException {
        String template = this.buildTemplate(sqlDir, fileName);
        if (Validator.isNull((String)template)) {
            return;
        }
        template = this.buildSQL(template);
        FileUtil.write((String)StringBundler.concat((String[])new String[]{sqlDir, "/", fileName, "/", fileName, "-", this.getServerName(), ".sql"}), (String)template);
    }

    public DBType getDBType() {
        return this._dbType;
    }

    public List<Index> getIndexes(Connection con) throws SQLException {
        return Collections.emptyList();
    }

    public int getMajorVersion() {
        return this._majorVersion;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    public String getTemplateBlob() {
        return this.getTemplate()[5];
    }

    public String getTemplateFalse() {
        return this.getTemplate()[2];
    }

    public String getTemplateTrue() {
        return this.getTemplate()[1];
    }

    public String getVersionString() {
        return this._majorVersion + "." + this._minorVersion;
    }

    public long increment() {
        return CounterLocalServiceUtil.increment();
    }

    public long increment(String name) {
        return CounterLocalServiceUtil.increment((String)name);
    }

    public long increment(String name, int size) {
        return CounterLocalServiceUtil.increment((String)name, (int)size);
    }

    public boolean isSupportsAlterColumnName() {
        return true;
    }

    public boolean isSupportsAlterColumnType() {
        return true;
    }

    public boolean isSupportsInlineDistinct() {
        return true;
    }

    public boolean isSupportsQueryingAfterException() {
        return true;
    }

    public boolean isSupportsScrollableResults() {
        return true;
    }

    public boolean isSupportsStringCaseSensitiveQuery() {
        return this._supportsStringCaseSensitiveQuery;
    }

    public boolean isSupportsUpdateWithInnerJoin() {
        return true;
    }

    public void runSQL(Connection con, String sql) throws IOException, SQLException {
        this.runSQL(con, new String[]{sql});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSQL(Connection con, String[] sqls) throws IOException, SQLException {
        Statement s = null;
        try {
            s = con.createStatement();
            for (int i = 0; i < sqls.length; ++i) {
                String sql = this.buildSQL(this.applyMaxStringIndexLengthLimitation(sqls[i]));
                if ((sql = SQLTransformer.transform(sql.trim())).endsWith(";")) {
                    sql = sql.substring(0, sql.length() - 1);
                }
                if (sql.endsWith("\ngo")) {
                    sql = sql.substring(0, sql.length() - 3);
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)sql);
                }
                try {
                    s.executeUpdate(sql);
                    continue;
                }
                catch (SQLException sqle) {
                    this.handleSQLException(sql, sqle);
                }
            }
        }
        finally {
            DataAccess.cleanUp((Statement)s);
        }
    }

    public void runSQL(String sql) throws IOException, SQLException {
        this.runSQL(new String[]{sql});
    }

    public void runSQL(String[] sqls) throws IOException, SQLException {
        Connection con = DataAccess.getConnection();
        try {
            this.runSQL(con, sqls);
        }
        finally {
            DataAccess.cleanUp((Connection)con);
        }
    }

    public void runSQLTemplate(String path) throws IOException, NamingException, SQLException {
        this.runSQLTemplate(path, true);
    }

    public void runSQLTemplate(String path, boolean failOnError) throws IOException, NamingException, SQLException {
        ClassLoader classLoader = ClassLoaderUtil.getContextClassLoader();
        InputStream is = classLoader.getResourceAsStream("com/liferay/portal/tools/sql/dependencies/" + path);
        if (is == null) {
            is = classLoader.getResourceAsStream(path);
        }
        if (is == null) {
            _log.error((Object)("Invalid path " + path));
            if (failOnError) {
                throw new IOException("Invalid path " + path);
            }
            return;
        }
        String template = StringUtil.read((InputStream)is);
        boolean evaluate = path.endsWith(".vm");
        this.runSQLTemplateString(template, evaluate, failOnError);
    }

    public void runSQLTemplateString(Connection connection, String template, boolean evaluate, boolean failOnError) throws IOException, NamingException, SQLException {
        template = this.applyMaxStringIndexLengthLimitation(template);
        if (evaluate) {
            try {
                template = this.evaluateVM(template.hashCode() + "", template);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(template));){
            StringBundler sb = new StringBundler();
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("##")) continue;
                if (line.startsWith("@include ")) {
                    int pos = line.indexOf(" ");
                    String includeFileName = line.substring(pos + 1);
                    ClassLoader classLoader = ClassLoaderUtil.getContextClassLoader();
                    InputStream is = classLoader.getResourceAsStream("com/liferay/portal/tools/sql/dependencies/" + includeFileName);
                    if (is == null) {
                        is = classLoader.getResourceAsStream(includeFileName);
                    }
                    String include = StringUtil.read((InputStream)is);
                    if (includeFileName.endsWith(".vm")) {
                        try {
                            include = this.evaluateVM(includeFileName, include);
                        }
                        catch (Exception e) {
                            _log.error((Object)e, (Throwable)e);
                        }
                    }
                    include = this.convertTimestamp(include);
                    include = this.replaceTemplate(include, this.getTemplate());
                    this.runSQLTemplateString(include, false, true);
                    continue;
                }
                sb.append(line);
                sb.append("\n");
                if (!line.endsWith(";")) continue;
                String sql = sb.toString();
                sb.setIndex(0);
                try {
                    if (!sql.equals("COMMIT_TRANSACTION;\n")) {
                        this.runSQL(connection, sql);
                        continue;
                    }
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)"Skip commit sql");
                }
                catch (IOException ioe) {
                    if (failOnError) {
                        throw ioe;
                    }
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)ioe.getMessage());
                }
                catch (SecurityException se) {
                    if (failOnError) {
                        throw se;
                    }
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)se.getMessage());
                }
                catch (SQLException sqle) {
                    if (failOnError) {
                        throw sqle;
                    }
                    String message = GetterUtil.getString((String)sqle.getMessage());
                    if (!message.startsWith("Duplicate key name") && _log.isWarnEnabled()) {
                        _log.warn((Object)(message + ": " + this.buildSQL(sql)));
                    }
                    if (!message.startsWith("Duplicate entry") && !message.startsWith("Specified key was too long")) continue;
                    _log.error((Object)line);
                }
            }
        }
    }

    public void runSQLTemplateString(String template, boolean evaluate, boolean failOnError) throws IOException, NamingException, SQLException {
        try (Connection connection = DataAccess.getConnection();){
            this.runSQLTemplateString(connection, template, evaluate, failOnError);
        }
    }

    public void setSupportsStringCaseSensitiveQuery(boolean supportsStringCaseSensitiveQuery) {
        if (_log.isInfoEnabled()) {
            if (supportsStringCaseSensitiveQuery) {
                _log.info((Object)"Database supports case sensitive queries");
            } else {
                _log.info((Object)"Database does not support case sensitive queries");
            }
        }
        this._supportsStringCaseSensitiveQuery = supportsStringCaseSensitiveQuery;
        SQLTransformer.reloadSQLTransformer();
    }

    public void updateIndexes(Connection con, String tablesSQL, String indexesSQL, boolean dropIndexes) throws IOException, SQLException {
        List<Index> indexes = this.getIndexes(con);
        HashSet<String> validIndexNames = null;
        if (dropIndexes) {
            validIndexNames = this.dropIndexes(con, tablesSQL, indexesSQL, indexes);
        } else {
            validIndexNames = new HashSet();
            for (Index index : indexes) {
                String indexName = StringUtil.toUpperCase((String)index.getIndexName());
                validIndexNames.add(indexName);
            }
        }
        indexesSQL = this.applyMaxStringIndexLengthLimitation(indexesSQL);
        this.addIndexes(con, indexesSQL, validIndexNames);
    }

    protected BaseDB(DBType dbType, int majorVersion, int minorVersion) {
        this._dbType = dbType;
        this._majorVersion = majorVersion;
        this._minorVersion = minorVersion;
        String[] actual = this.getTemplate();
        for (int i = 0; i < TEMPLATE.length; ++i) {
            this._templateMap.put(TEMPLATE[i], actual[i]);
        }
    }

    protected String applyMaxStringIndexLengthLimitation(String template) {
        if (!template.contains("[$COLUMN_LENGTH:")) {
            return template;
        }
        DBType dbType = this.getDBType();
        int stringIndexMaxLength = GetterUtil.getInteger((String)PropsUtil.get((String)"database.string.index.max.length", (Filter)new Filter(dbType.getName())), (int)-1);
        String replacement = "\\(" + stringIndexMaxLength + "\\)";
        Matcher matcher = _columnLengthPattern.matcher(template);
        if (stringIndexMaxLength < 0) {
            if (dbType.equals((Object)DBType.SYBASE)) {
                replacement = "";
            } else {
                return matcher.replaceAll("");
            }
        }
        boolean remove = false;
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int length = Integer.valueOf(matcher.group(1));
            if (dbType.equals((Object)DBType.SYBASE) && length > 1250) {
                matcher.appendReplacement(sb, "%%REMOVE%%");
                remove = true;
                continue;
            }
            if (length > stringIndexMaxLength) {
                matcher.appendReplacement(sb, replacement);
                continue;
            }
            matcher.appendReplacement(sb, "");
        }
        matcher.appendTail(sb);
        String string = sb.toString();
        if (dbType.equals((Object)DBType.SYBASE) && remove) {
            Object[] strings = StringUtil.split((String)string, (String)"\n");
            for (int i = 0; i < strings.length; ++i) {
                if (!strings[i].contains("%%REMOVE%%")) continue;
                strings[i] = "";
            }
            return StringUtil.merge((Object[])strings, (String)"\n");
        }
        return string;
    }

    protected String[] buildColumnNameTokens(String line) {
        String[] words = StringUtil.split((String)line, (char)' ');
        String nullable = "";
        if (words.length == 7) {
            nullable = "not null;";
        }
        String[] template = new String[]{words[1], words[2], words[3], words[4], nullable};
        return template;
    }

    protected String[] buildColumnTypeTokens(String line) {
        String[] words = StringUtil.split((String)line, (char)' ');
        String nullable = "";
        if (words.length == 6) {
            nullable = "not null;";
        } else if (words.length == 5) {
            nullable = words[4];
        } else if (words.length == 4) {
            nullable = "not null;";
            if (words[3].endsWith(";")) {
                words[3] = words[3].substring(0, words[3].length() - 1);
            }
        }
        String[] template = new String[]{words[1], words[2], "", words[3], nullable};
        return template;
    }

    protected abstract String buildCreateFileContent(String var1, String var2, int var3) throws IOException;

    protected String[] buildTableNameTokens(String line) {
        String[] words = StringUtil.split((String)line, (String)" ");
        return new String[]{words[1], words[2]};
    }

    protected String buildTemplate(String sqlDir, String fileName) throws IOException {
        String template = this.readFile(StringBundler.concat((String[])new String[]{sqlDir, "/", fileName, ".sql"}));
        if (fileName.equals("portal") || fileName.equals("update-5.0.1-5.1.0")) {
            StringBundler sb = new StringBundler();
            try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(template));){
                String line = null;
                while ((line = unsyncBufferedReader.readLine()) != null) {
                    if (line.startsWith("@include ")) {
                        int pos = line.indexOf(" ");
                        String includeFileName = line.substring(pos + 1);
                        File includeFile = new File(sqlDir + "/" + includeFileName);
                        if (!includeFile.exists()) continue;
                        String include = FileUtil.read((File)includeFile);
                        if (includeFileName.endsWith(".vm")) {
                            try {
                                include = this.evaluateVM(includeFileName, include);
                            }
                            catch (Exception e) {
                                _log.error((Object)e, (Throwable)e);
                            }
                        }
                        include = this.convertTimestamp(include);
                        include = this.replaceTemplate(include, this.getTemplate());
                        sb.append(include);
                        sb.append("\n\n");
                        continue;
                    }
                    sb.append(line);
                    sb.append("\n");
                }
            }
            template = sb.toString();
        }
        if (fileName.equals("indexes")) {
            template = this.applyMaxStringIndexLengthLimitation(template);
            if (this.getDBType() == DBType.SYBASE) {
                template = this.removeBooleanIndexes(sqlDir, template);
            }
        }
        return template;
    }

    protected String convertTimestamp(String data) {
        String s = null;
        if (this instanceof MySQLDB) {
            s = StringUtil.replace((String)data, (String)"SPECIFIC_TIMESTAMP_", (String)"");
        } else {
            Matcher matcher = _timestampPattern.matcher(data);
            s = matcher.replaceAll("CURRENT_TIMESTAMP");
        }
        return s;
    }

    protected Set<String> dropIndexes(Connection con, String tablesSQL, String indexesSQL, List<Index> indexes) throws IOException, SQLException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Dropping stale indexes");
        }
        HashSet<String> validIndexNames = new HashSet<String>();
        if (indexes.isEmpty()) {
            return validIndexNames;
        }
        String tablesSQLLowerCase = StringUtil.toLowerCase((String)tablesSQL);
        String indexesSQLLowerCase = StringUtil.toLowerCase((String)indexesSQL);
        String[] lines = StringUtil.splitLines((String)indexesSQL);
        HashSet<String> indexNames = new HashSet<String>();
        for (String line : lines) {
            if (Validator.isNull((String)line)) continue;
            IndexMetadata indexMetadata = IndexMetadataFactoryUtil.createIndexMetadata((String)line);
            indexNames.add(StringUtil.toLowerCase((String)indexMetadata.getIndexName()));
        }
        for (Index index : indexes) {
            String indexNameUpperCase = StringUtil.toUpperCase((String)index.getIndexName());
            String indexNameLowerCase = StringUtil.toLowerCase((String)indexNameUpperCase);
            String tableName = index.getTableName();
            String tableNameLowerCase = StringUtil.toLowerCase((String)tableName);
            boolean unique = index.isUnique();
            validIndexNames.add(indexNameUpperCase);
            if (indexNames.contains(indexNameLowerCase) ? unique && indexesSQLLowerCase.contains("create unique index " + indexNameLowerCase + " ") || !unique && indexesSQLLowerCase.contains("create index " + indexNameLowerCase + " ") : !tablesSQLLowerCase.contains(CREATE_TABLE + tableNameLowerCase + " (")) continue;
            validIndexNames.remove(indexNameUpperCase);
            String sql = StringBundler.concat((String[])new String[]{"drop index ", indexNameUpperCase, " on ", tableName});
            if (_log.isInfoEnabled()) {
                _log.info((Object)sql);
            }
            this.runSQL(con, sql);
        }
        return validIndexNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String evaluateVM(String templateId, String templateContent) throws Exception {
        if (Validator.isNull((String)templateContent)) {
            return "";
        }
        ClassLoader classLoader = ClassLoaderUtil.getContextClassLoader();
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        try {
            ClassLoaderUtil.setContextClassLoader((ClassLoader)ClassLoaderUtil.getPortalClassLoader());
            StringTemplateResource stringTemplateResource = new StringTemplateResource(templateId, templateContent);
            Template template = TemplateManagerUtil.getTemplate((String)"vm", (TemplateResource)stringTemplateResource, (boolean)false);
            template.put((Object)"counter", (Object)new SimpleCounter());
            template.put((Object)"portalUUIDUtil", PortalUUIDUtil.class);
            template.processTemplate((Writer)unsyncStringWriter);
        }
        finally {
            ClassLoaderUtil.setContextClassLoader((ClassLoader)classLoader);
        }
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(unsyncStringWriter.toString()));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                line = line.trim();
                sb.append(line);
                sb.append("\n");
            }
        }
        templateContent = sb.toString();
        templateContent = StringUtil.replace((String)templateContent, (String)"\n\n\n", (String)"\n\n");
        return templateContent;
    }

    protected String getCreateTablesContent(String sqlDir, String suffix) throws IOException {
        StringBundler sb = new StringBundler(8);
        sb.append(sqlDir);
        if (!sqlDir.endsWith("/WEB-INF/sql")) {
            sb.append("/portal");
            sb.append(suffix);
            sb.append("/portal");
        } else {
            sb.append("/tables");
            sb.append(suffix);
            sb.append("/tables");
        }
        sb.append(suffix);
        sb.append("-");
        sb.append(this.getServerName());
        sb.append(".sql");
        return this.readFile(sb.toString());
    }

    protected abstract String getServerName();

    protected String getSuffix(int type) {
        if (type == 0) {
            return "-bare";
        }
        return "";
    }

    protected abstract String[] getTemplate();

    protected void handleSQLException(String sql, SQLException sqle) throws SQLException {
        if (_log.isDebugEnabled()) {
            StringBundler sb = new StringBundler(10);
            sb.append("SQL: ");
            sb.append(sql);
            sb.append("\nSQL state: ");
            sb.append(sqle.getSQLState());
            sb.append("\nVendor: ");
            sb.append((Object)this.getDBType());
            sb.append("\nVendor error code: ");
            sb.append(sqle.getErrorCode());
            sb.append("\nVendor error message: ");
            sb.append(sqle.getMessage());
            _log.debug((Object)sb.toString());
        }
        throw sqle;
    }

    protected String readFile(String fileName) throws IOException {
        if (FileUtil.exists((String)fileName)) {
            return FileUtil.read((String)fileName);
        }
        return "";
    }

    protected String readSQL(String fileName, String comments, String eol) throws IOException {
        if (!FileUtil.exists((String)fileName)) {
            return "";
        }
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new FileReader(new File(fileName)));){
            StringBundler sb = new StringBundler();
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (line.startsWith(comments)) continue;
                if ((line = StringUtil.removeChars((String)line, (char[])new char[]{'\n', '\t'})).endsWith(";")) {
                    sb.append(line.substring(0, line.length() - 1));
                    sb.append(eol);
                    continue;
                }
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
    }

    protected String removeBooleanIndexes(String sqlDir, String data) throws IOException {
        String portalData = this.readFile(sqlDir + "/portal-tables.sql");
        if (Validator.isNull((String)portalData)) {
            return "";
        }
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));){
            StringBundler sb = new StringBundler();
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                boolean append = true;
                int x = line.indexOf(" on ");
                if (x != -1) {
                    int y = line.indexOf(" (", x);
                    String table = line.substring(x + 4, y);
                    x = y + 2;
                    y = line.indexOf(")", x);
                    String[] columns = StringUtil.split((String)line.substring(x, y));
                    x = portalData.indexOf(CREATE_TABLE + table + " (");
                    y = portalData.indexOf(");", x);
                    String portalTableData = portalData.substring(x, y);
                    for (int i = 0; i < columns.length; ++i) {
                        if (!portalTableData.contains(columns[i].trim() + " BOOLEAN")) continue;
                        append = false;
                        break;
                    }
                }
                if (!append) continue;
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }

    protected String removeInserts(String data) throws IOException {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));){
            StringBundler sb = new StringBundler();
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (line.startsWith("insert into ") || line.startsWith("update ")) continue;
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }

    protected String removeLongInserts(String data) throws IOException {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));){
            StringBundler sb = new StringBundler();
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (line.startsWith("insert into Image (") || line.startsWith("insert into JournalArticle (")) continue;
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }

    protected String removeNull(String content) {
        content = StringUtil.replace((String)content, (String)" = null", (String)" = NULL");
        content = StringUtil.replace((String)content, (String)" is null", (String)" IS NULL");
        content = StringUtil.replace((String)content, (String)" not null", (String)" not_null");
        content = StringUtil.replace((String)content, (String)" null", (String)"");
        content = StringUtil.replace((String)content, (String)" not_null", (String)" not null");
        return content;
    }

    protected String replaceTemplate(String template, String[] actual) {
        if (template == null || TEMPLATE == null || actual == null) {
            return null;
        }
        if (TEMPLATE.length != actual.length) {
            return template;
        }
        StringBundler sb = null;
        int endIndex = 0;
        Matcher matcher = _templatePattern.matcher(template);
        while (matcher.find()) {
            int startIndex = matcher.start();
            if (sb == null) {
                sb = new StringBundler();
            }
            sb.append(template.substring(endIndex, startIndex));
            endIndex = matcher.end();
            String matched = template.substring(startIndex, endIndex);
            sb.append(this._templateMap.get(matched));
        }
        if (sb == null) {
            return template;
        }
        if (template.length() > endIndex) {
            sb.append(template.substring(endIndex));
        }
        return sb.toString();
    }

    protected abstract String reword(String var1) throws IOException;

    static {
        _timestampPattern = Pattern.compile("SPECIFIC_TIMESTAMP_\\d+");
        StringBundler sb = new StringBundler(TEMPLATE.length * 5 - 6);
        for (int i = 0; i < TEMPLATE.length; ++i) {
            String variable = TEMPLATE[i];
            if (variable.equals("##") || variable.equals("'01/01/1970'")) {
                sb.append(variable);
            } else {
                sb.append("(?<!\\[\\$)");
                sb.append(variable);
                sb.append("(?!\\$\\])");
                sb.append("\\b");
            }
            sb.append("|");
        }
        sb.setIndex(sb.index() - 1);
        _templatePattern = Pattern.compile(sb.toString());
    }
}

